/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.nio.ByteBuffer;
import net.minestom.server.entity.Player;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.ClientPacketsHandler;
import net.minestom.server.network.packet.client.handshake.ClientHandshakePacket;
import net.minestom.server.network.player.PlayerConnection;
import org.jetbrains.annotations.NotNull;

public class PacketProcessor {
    private final ClientPacketsHandler statusHandler = new ClientPacketsHandler.Status();
    private final ClientPacketsHandler loginHandler = new ClientPacketsHandler.Login();
    private final ClientPacketsHandler configurationHandler = new ClientPacketsHandler.Configuration();
    private final ClientPacketsHandler playHandler = new ClientPacketsHandler.Play();
    private final PacketListenerManager packetListenerManager;

    public PacketProcessor(@NotNull PacketListenerManager packetListenerManager) {
        this.packetListenerManager = packetListenerManager;
    }

    @NotNull
    public ClientPacket create(@NotNull ConnectionState connectionState, int packetId, ByteBuffer body) {
        NetworkBuffer buffer = new NetworkBuffer(body);
        ClientPacket clientPacket = switch (connectionState) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionState.HANDSHAKE -> {
                if (!$assertionsDisabled && packetId != 0) {
                    throw new AssertionError();
                }
                yield new ClientHandshakePacket(buffer);
            }
            case ConnectionState.STATUS -> this.statusHandler.create(packetId, buffer);
            case ConnectionState.LOGIN -> this.loginHandler.create(packetId, buffer);
            case ConnectionState.CONFIGURATION -> this.configurationHandler.create(packetId, buffer);
            case ConnectionState.PLAY -> this.playHandler.create(packetId, buffer);
        };
        body.position(buffer.readIndex());
        return clientPacket;
    }

    public ClientPacket process(@NotNull PlayerConnection connection, int packetId, ByteBuffer body) {
        ClientPacket packet = this.create(connection.getConnectionState(), packetId, body);
        switch (connection.getConnectionState()) {
            case HANDSHAKE: 
            case STATUS: 
            case LOGIN: {
                this.packetListenerManager.processClientPacket(packet, connection);
                break;
            }
            case CONFIGURATION: 
            case PLAY: {
                Player player = connection.getPlayer();
                assert (player != null);
                player.addPacketToQueue(packet);
            }
        }
        return packet;
    }
}

