/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.metadata.animal.FrogMeta;
import net.minestom.server.entity.metadata.animal.SnifferMeta;
import net.minestom.server.entity.metadata.animal.tameable.CatMeta;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBufferTypes;
import net.minestom.server.network.packet.server.play.data.DeathLocation;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.Either;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTReader;
import org.jglrxavpok.hephaistos.nbt.NBTWriter;

@ApiStatus.Experimental
public final class NetworkBuffer {
    public static final Type<Boolean> BOOLEAN = NetworkBufferTypes.BOOLEAN;
    public static final Type<Byte> BYTE = NetworkBufferTypes.BYTE;
    public static final Type<Short> SHORT = NetworkBufferTypes.SHORT;
    public static final Type<Integer> UNSIGNED_SHORT = NetworkBufferTypes.UNSIGNED_SHORT;
    public static final Type<Integer> INT = NetworkBufferTypes.INT;
    public static final Type<Long> LONG = NetworkBufferTypes.LONG;
    public static final Type<Float> FLOAT = NetworkBufferTypes.FLOAT;
    public static final Type<Double> DOUBLE = NetworkBufferTypes.DOUBLE;
    public static final Type<Integer> VAR_INT = NetworkBufferTypes.VAR_INT;
    public static final Type<Long> VAR_LONG = NetworkBufferTypes.VAR_LONG;
    public static final Type<byte[]> RAW_BYTES = NetworkBufferTypes.RAW_BYTES;
    public static final Type<String> STRING = NetworkBufferTypes.STRING;
    public static final Type<NBT> NBT = NetworkBufferTypes.NBT;
    public static final Type<Point> BLOCK_POSITION = NetworkBufferTypes.BLOCK_POSITION;
    public static final Type<Component> COMPONENT = NetworkBufferTypes.COMPONENT;
    public static final Type<Component> JSON_COMPONENT = NetworkBufferTypes.JSON_COMPONENT;
    public static final Type<UUID> UUID = NetworkBufferTypes.UUID;
    public static final Type<@Nullable ItemStack> ITEM = NetworkBufferTypes.ITEM;
    public static final Type<byte[]> BYTE_ARRAY = NetworkBufferTypes.BYTE_ARRAY;
    public static final Type<long[]> LONG_ARRAY = NetworkBufferTypes.LONG_ARRAY;
    public static final Type<int[]> VAR_INT_ARRAY = NetworkBufferTypes.VAR_INT_ARRAY;
    public static final Type<long[]> VAR_LONG_ARRAY = NetworkBufferTypes.VAR_LONG_ARRAY;
    public static final Type<Component> OPT_CHAT = NetworkBufferTypes.OPT_CHAT;
    public static final Type<Point> ROTATION = NetworkBufferTypes.ROTATION;
    public static final Type<Point> OPT_BLOCK_POSITION = NetworkBufferTypes.OPT_BLOCK_POSITION;
    public static final Type<Direction> DIRECTION = NetworkBufferTypes.DIRECTION;
    public static final Type<UUID> OPT_UUID = NetworkBufferTypes.OPT_UUID;
    public static final Type<Integer> BLOCK_STATE = NetworkBufferTypes.BLOCK_STATE;
    public static final Type<Integer> OPT_BLOCK_STATE = NetworkBufferTypes.OPT_BLOCK_STATE;
    public static final Type<int[]> VILLAGER_DATA = NetworkBufferTypes.VILLAGER_DATA;
    public static final Type<Integer> OPT_VAR_INT = NetworkBufferTypes.OPT_VAR_INT;
    public static final Type<Entity.Pose> POSE = NetworkBufferTypes.POSE;
    public static final Type<DeathLocation> DEATH_LOCATION = NetworkBufferTypes.DEATH_LOCATION;
    public static final Type<CatMeta.Variant> CAT_VARIANT = NetworkBufferTypes.CAT_VARIANT;
    public static final Type<FrogMeta.Variant> FROG_VARIANT = NetworkBufferTypes.FROG_VARIANT;
    public static final Type<SnifferMeta.State> SNIFFER_STATE = NetworkBufferTypes.SNIFFER_STATE;
    public static final Type<Point> VECTOR3 = NetworkBufferTypes.VECTOR3;
    public static final Type<Point> VECTOR3D = NetworkBufferTypes.VECTOR3D;
    public static final Type<float[]> QUATERNION = NetworkBufferTypes.QUATERNION;
    ByteBuffer nioBuffer;
    final boolean resizable;
    int writeIndex;
    int readIndex;
    NBTWriter nbtWriter;
    NBTReader nbtReader;

    public NetworkBuffer(@NotNull ByteBuffer buffer, boolean resizable) {
        this.nioBuffer = buffer.order(ByteOrder.BIG_ENDIAN);
        this.resizable = resizable;
        this.writeIndex = buffer.position();
        this.readIndex = buffer.position();
    }

    public NetworkBuffer(@NotNull ByteBuffer buffer) {
        this(buffer, true);
    }

    public NetworkBuffer(int initialCapacity) {
        this(ByteBuffer.allocateDirect(initialCapacity), true);
    }

    public NetworkBuffer() {
        this(1024);
    }

    public <T> void write(@NotNull Type<T> type, @NotNull T value) {
        NetworkBufferTypes.TypeImpl impl = (NetworkBufferTypes.TypeImpl)type;
        long length = impl.writer().write(this, value);
        if (length != -1L) {
            this.writeIndex = (int)((long)this.writeIndex + length);
        }
    }

    public <T> void write(@NotNull Writer writer) {
        writer.write(this);
    }

    @NotNull
    public <T> T read(@NotNull Type<T> type) {
        NetworkBufferTypes.TypeImpl impl = (NetworkBufferTypes.TypeImpl)type;
        return impl.reader().read(this);
    }

    public <T> void writeOptional(@NotNull Type<T> type, @Nullable T value) {
        this.write(BOOLEAN, value != null);
        if (value != null) {
            this.write(type, value);
        }
    }

    public void writeOptional(@Nullable Writer writer) {
        this.write(BOOLEAN, writer != null);
        if (writer != null) {
            this.write(writer);
        }
    }

    @Nullable
    public <T> T readOptional(@NotNull Type<T> type) {
        return this.read(BOOLEAN) != false ? (T)this.read(type) : null;
    }

    @Nullable
    public <T> T readOptional(@NotNull @NotNull Function<@NotNull NetworkBuffer, @NotNull T> function) {
        return this.read(BOOLEAN) != false ? (T)function.apply(this) : null;
    }

    public <T> void writeCollection(@NotNull Type<T> type, @Nullable Collection<@NotNull T> values) {
        if (values == null) {
            this.write(BYTE, (byte)0);
            return;
        }
        this.write(VAR_INT, values.size());
        for (T value : values) {
            this.write(type, value);
        }
    }

    @SafeVarargs
    public final <T> void writeCollection(@NotNull Type<T> type, T ... values) {
        this.writeCollection(type, (Collection<T>)(values == null ? null : List.of(values)));
    }

    public <T extends Writer> void writeCollection(@Nullable Collection<@NotNull T> values) {
        if (values == null) {
            this.write(BYTE, (byte)0);
            return;
        }
        this.write(VAR_INT, values.size());
        for (Writer value : values) {
            this.write(value);
        }
    }

    public <T> void writeCollection(@Nullable Collection<@NotNull T> values, @NotNull @NotNull BiConsumer<@NotNull NetworkBuffer, @NotNull T> consumer) {
        if (values == null) {
            this.write(BYTE, (byte)0);
            return;
        }
        this.write(VAR_INT, values.size());
        for (T value : values) {
            consumer.accept(this, (NetworkBuffer)value);
        }
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> readCollection(@NotNull Type<T> type, int maxSize) {
        int size = this.read(VAR_INT);
        Check.argCondition(size > maxSize, "Collection size ({0}) is higher than the maximum allowed size ({1})", size, maxSize);
        ArrayList<T> values = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            values.add(this.read(type));
        }
        return values;
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> readCollection(@NotNull @NotNull Function<@NotNull NetworkBuffer, @NotNull T> function, int maxSize) {
        int size = this.read(VAR_INT);
        Check.argCondition(size > maxSize, "Collection size ({0}) is higher than the maximum allowed size ({1})", size, maxSize);
        ArrayList<T> values = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            values.add(function.apply(this));
        }
        return values;
    }

    public <L, R> void writeEither(Either<L, R> either, BiConsumer<NetworkBuffer, L> leftWriter, BiConsumer<NetworkBuffer, R> rightWriter) {
        if (either.isLeft()) {
            this.write(BOOLEAN, true);
            leftWriter.accept(this, either.left());
        } else {
            this.write(BOOLEAN, false);
            rightWriter.accept(this, either.right());
        }
    }

    @NotNull
    public <L, R> Either<L, R> readEither(@NotNull Function<NetworkBuffer, L> leftReader, Function<NetworkBuffer, R> rightReader) {
        if (this.read(BOOLEAN).booleanValue()) {
            return Either.left(leftReader.apply(this));
        }
        return Either.right(rightReader.apply(this));
    }

    public <E extends Enum<?>> void writeEnum(@NotNull Class<E> enumClass, @NotNull E value) {
        this.write(VAR_INT, value.ordinal());
    }

    @NotNull
    public <E extends Enum<?>> E readEnum(@NotNull @NotNull Class<@NotNull E> enumClass) {
        return (E)((Enum[])enumClass.getEnumConstants())[this.read(VAR_INT)];
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> enumSet, Class<E> enumType) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        BitSet bitSet = new BitSet(values.length);
        for (int i = 0; i < values.length; ++i) {
            bitSet.set(i, enumSet.contains(values[i]));
        }
        this.writeFixedBitSet(bitSet, values.length);
    }

    @NotNull
    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> enumType) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        BitSet bitSet = this.readFixedBitSet(values.length);
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumType);
        for (int i = 0; i < values.length; ++i) {
            if (!bitSet.get(i)) continue;
            enumSet.add(values[i]);
        }
        return enumSet;
    }

    public void writeFixedBitSet(BitSet set, int length) {
        int setLength = set.length();
        if (setLength > length) {
            throw new IllegalArgumentException("BitSet is larger than expected size (" + setLength + ">" + length + ")");
        }
        byte[] array = set.toByteArray();
        this.write(RAW_BYTES, array);
    }

    @NotNull
    public BitSet readFixedBitSet(int length) {
        byte[] array = this.readBytes((length + 7) / 8);
        return BitSet.valueOf(array);
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.nioBuffer.get(this.readIndex, bytes, 0, length);
        this.readIndex += length;
        return bytes;
    }

    public void copyTo(int srcOffset, byte @NotNull [] dest, int destOffset, int length) {
        this.nioBuffer.get(srcOffset, dest, destOffset, length);
    }

    public byte @NotNull [] extractBytes(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> extractor) {
        int startingPosition = this.readIndex();
        extractor.accept(this);
        int endingPosition = this.readIndex();
        byte[] output = new byte[endingPosition - startingPosition];
        this.copyTo(startingPosition, output, 0, output.length);
        return output;
    }

    public void clear() {
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public int writeIndex() {
        return this.writeIndex;
    }

    public int readIndex() {
        return this.readIndex;
    }

    public void writeIndex(int writeIndex) {
        this.writeIndex = writeIndex;
    }

    public void readIndex(int readIndex) {
        this.readIndex = readIndex;
    }

    public int skipWrite(int length) {
        int oldWriteIndex = this.writeIndex;
        this.writeIndex += length;
        return oldWriteIndex;
    }

    public int readableBytes() {
        return this.writeIndex - this.readIndex;
    }

    void ensureSize(int length) {
        if (!this.resizable) {
            return;
        }
        if (this.nioBuffer.capacity() < this.writeIndex + length) {
            int newCapacity = Math.max(this.nioBuffer.capacity() * 2, this.writeIndex + length);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            this.nioBuffer.position(0);
            newBuffer.put(this.nioBuffer);
            this.nioBuffer = newBuffer.clear();
        }
    }

    public static byte[] makeArray(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> writing) {
        NetworkBuffer writer = new NetworkBuffer();
        writing.accept(writer);
        byte[] bytes = new byte[writer.writeIndex];
        writer.copyTo(0, bytes, 0, bytes.length);
        return bytes;
    }

    @FunctionalInterface
    public static interface Writer {
        public void write(@NotNull NetworkBuffer var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Type<T> {
    }
}

