/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.painter;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.painter.Painter;
import net.minestom.server.instance.painter.PreparedOperation;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

record PainterImpl(List<Instruction> instructions) implements Painter
{
    public PainterImpl {
        instructions = List.copyOf(instructions);
    }

    static PainterImpl paint(Consumer<Painter.ReadableWorld> consumer) {
        WorldImpl world = new WorldImpl();
        consumer.accept(world);
        return new PainterImpl(world.instructions);
    }

    @Override
    public Palette sectionAt(int sectionX, int sectionY, int sectionZ) {
        return PainterImpl.sectionAt(this.instructions, sectionX, sectionY, sectionZ);
    }

    static void applyInstruction(int sectionX, int sectionY, int sectionZ, Palette palette, Point offset, Instruction instruction) {
        if (!PainterImpl.sectionRelevant(instruction, sectionX, sectionY, sectionZ, offset)) {
            return;
        }
        int minSectionX = sectionX * 16;
        int maxSectionX = minSectionX + 16;
        int minSectionY = sectionY * 16;
        int maxSectionY = minSectionY + 16;
        int minSectionZ = sectionZ * 16;
        int maxSectionZ = minSectionZ + 16;
        Instruction instruction2 = instruction;
        Objects.requireNonNull(instruction2);
        Instruction instruction3 = instruction2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instruction.SetBlock.class, Instruction.Operation2d.class, Instruction.Cuboid.class}, (Object)instruction3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Instruction.SetBlock setBlock = (Instruction.SetBlock)instruction3;
                int absX = setBlock.x() + offset.blockX();
                int absY = setBlock.y() + offset.blockY();
                int absZ = setBlock.z() + offset.blockZ();
                if (absX < minSectionX || absX >= maxSectionX || absY < minSectionY || absY >= maxSectionY || absZ < minSectionZ || absZ >= maxSectionZ) {
                    return;
                }
                int localX = ChunkUtils.toSectionRelativeCoordinate(absX);
                int localY = ChunkUtils.toSectionRelativeCoordinate(absY);
                int localZ = ChunkUtils.toSectionRelativeCoordinate(absZ);
                palette.set(localX, localY, localZ, setBlock.block().stateId());
                break;
            }
            case 1: {
                Instruction.Operation2d noise2D = (Instruction.Operation2d)instruction3;
                Bounds bounds = noise2D.operation().bounds();
                int maxX = bounds.max().blockX() + 16;
                int minX = bounds.min().blockX() - 16;
                int maxZ = bounds.max().blockZ() + 16;
                int minZ = bounds.min().blockZ() - 16;
                int negX = -Math.max(maxX, 0);
                int negZ = -Math.max(maxZ, 0);
                int posX = Math.max(0, -minX);
                int posZ = Math.max(0, -minZ);
                for (int x = negX; x < posX; ++x) {
                    for (int z = negZ; z < posZ; ++z) {
                        int absX = x + 16 * sectionX + offset.blockX();
                        int absZ = z + 16 * sectionZ + offset.blockZ();
                        if (!noise2D.test().test(absX, 0, absZ)) continue;
                        Vec spreadOffset = new Vec(absX, offset.y(), absZ);
                        for (Instruction opInstruction : noise2D.operation().instructions()) {
                            PainterImpl.applyInstruction(sectionX, sectionY, sectionZ, palette, spreadOffset, opInstruction);
                        }
                    }
                }
                break;
            }
            case 2: {
                Instruction.Cuboid cuboid = (Instruction.Cuboid)instruction3;
                for (int x = cuboid.min().blockX(); x < cuboid.max().blockX(); ++x) {
                    for (int y = cuboid.min().blockY(); y < cuboid.max().blockY(); ++y) {
                        for (int z = cuboid.min().blockZ(); z < cuboid.max().blockZ(); ++z) {
                            Block block = cuboid.block();
                            if (x < minSectionX || x >= maxSectionX || y < minSectionY || y >= maxSectionY || z < minSectionZ || z >= maxSectionZ) continue;
                            int localX = ChunkUtils.toSectionRelativeCoordinate(x);
                            int localY = ChunkUtils.toSectionRelativeCoordinate(y);
                            int localZ = ChunkUtils.toSectionRelativeCoordinate(z);
                            palette.set(localX, localY, localZ, block.stateId());
                        }
                    }
                }
            }
        }
    }

    static Palette sectionAt(List<Instruction> instructions, int sectionX, int sectionY, int sectionZ) {
        Palette palette = Palette.blocks();
        for (Instruction instruction : instructions) {
            PainterImpl.applyInstruction(sectionX, sectionY, sectionZ, palette, Vec.ZERO, instruction);
        }
        return palette;
    }

    static boolean sectionRelevant(Instruction instruction, int sectionX, int sectionY, int sectionZ, Point offset) {
        Instruction instruction2 = instruction;
        Objects.requireNonNull(instruction2);
        Instruction instruction3 = instruction2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instruction.SetBlock.class, Instruction.Cuboid.class, Instruction.Operation2d.class}, (Object)instruction3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Instruction.SetBlock setBlock = (Instruction.SetBlock)instruction3;
                if (ChunkUtils.getChunkCoordinate(setBlock.x() + offset.blockX()) == sectionX && ChunkUtils.getChunkCoordinate(setBlock.y() + offset.blockY()) == sectionY && ChunkUtils.getChunkCoordinate(setBlock.z() + offset.blockZ()) == sectionZ) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Instruction.Cuboid cuboid = (Instruction.Cuboid)instruction3;
                Vec min = cuboid.min();
                Vec max = cuboid.max();
                int minX = ChunkUtils.getChunkCoordinate(min.blockX() + offset.blockX());
                int minY = ChunkUtils.getChunkCoordinate(min.blockY() + offset.blockY());
                int minZ = ChunkUtils.getChunkCoordinate(min.blockZ() + offset.blockZ());
                int maxX = ChunkUtils.getChunkCoordinate(max.blockX() + offset.blockX());
                int maxY = ChunkUtils.getChunkCoordinate(max.blockY() + offset.blockY());
                int maxZ = ChunkUtils.getChunkCoordinate(max.blockZ() + offset.blockZ());
                if (sectionX >= minX && sectionX <= maxX && sectionY >= minY && sectionY <= maxY && sectionZ >= minZ && sectionZ <= maxZ) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Instruction.Operation2d noise2D = (Instruction.Operation2d)instruction3;
                yield true;
            }
        };
    }

    static final class WorldImpl
    implements Painter.ReadableWorld {
        private final List<Instruction> instructions = new ArrayList<Instruction>();

        WorldImpl() {
        }

        @Override
        public @UnknownNullability Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
            int sectionX = ChunkUtils.getChunkCoordinate(x);
            int sectionY = ChunkUtils.getChunkCoordinate(y);
            int sectionZ = ChunkUtils.getChunkCoordinate(z);
            Palette palette = PainterImpl.sectionAt(this.instructions, sectionX, sectionY, sectionZ);
            int localX = ChunkUtils.toSectionRelativeCoordinate(x);
            int localY = ChunkUtils.toSectionRelativeCoordinate(y);
            int localZ = ChunkUtils.toSectionRelativeCoordinate(z);
            int stateId = palette.get(localX, localY, localZ);
            return Block.fromStateId(stateId);
        }

        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            this.append(new Instruction.SetBlock(x, y, z, block));
        }

        void append(Instruction instruction) {
            this.instructions.add(instruction);
        }

        @Override
        public void cuboid(Point min, Point max, Block block) {
            this.append(new Instruction.Cuboid(Vec.fromPoint(min), Vec.fromPoint(max), block));
        }

        @Override
        public void operation2d(Painter.PosPredicate noise, Painter.Operation operation) {
            PreparedOperation prepared = PreparedOperation.compile(operation);
            if (prepared == null) {
                return;
            }
            this.append(new Instruction.Operation2d(noise, prepared));
        }
    }

    static sealed interface Instruction {

        public record Cuboid(Vec min, Vec max, Block block) implements Instruction
        {
        }

        public record Operation2d(Painter.PosPredicate test, PreparedOperation operation) implements Instruction
        {
        }

        public record SetBlock(int x, int y, int z, Block block) implements Instruction
        {
        }
    }

    record Bounds(Vec min, Vec max) {
    }
}

