/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.painter;

import java.util.ArrayList;
import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.painter.Painter;
import net.minestom.server.instance.painter.PainterImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record PreparedOperation(PainterImpl.Bounds bounds, List<PainterImpl.Instruction> instructions) {
    @Nullable
    static PreparedOperation compile(Painter.Operation operation) {
        StagingRelWorld stagingRelWorld = new StagingRelWorld();
        operation.apply(stagingRelWorld);
        if (stagingRelWorld.relInstructions.isEmpty()) {
            return null;
        }
        return new PreparedOperation(new PainterImpl.Bounds(stagingRelWorld.min, stagingRelWorld.max.add(Vec.ONE)), stagingRelWorld.relInstructions);
    }

    static final class StagingRelWorld
    implements Painter.World {
        private final List<PainterImpl.Instruction> relInstructions = new ArrayList<PainterImpl.Instruction>();
        private Vec min = new Vec(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        private Vec max = new Vec(Double.MIN_VALUE, Double.MIN_VALUE, Double.MIN_VALUE);

        StagingRelWorld() {
        }

        private void adjustBounds(int x, int y, int z) {
            if ((double)x < this.min.x()) {
                this.min = this.min.withX(x);
            }
            if ((double)y < this.min.y()) {
                this.min = this.min.withY(y);
            }
            if ((double)z < this.min.z()) {
                this.min = this.min.withZ(z);
            }
            if ((double)x > this.max.x()) {
                this.max = this.max.withX(x);
            }
            if ((double)y > this.max.y()) {
                this.max = this.max.withY(y);
            }
            if ((double)z > this.max.z()) {
                this.max = this.max.withZ(z);
            }
        }

        @Override
        public void cuboid(Point min, Point max, Block block) {
            this.relInstructions.add(new PainterImpl.Instruction.Cuboid(Vec.fromPoint(min), Vec.fromPoint(max), block));
            this.adjustBounds(min.blockX(), min.blockY(), min.blockZ());
            this.adjustBounds(max.blockX(), max.blockY(), max.blockZ());
        }

        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            this.relInstructions.add(new PainterImpl.Instruction.SetBlock(x, y, z, block));
            this.adjustBounds(x, y, z);
        }

        @Override
        public void fill(Block block) {
            this.relInstructions.add(new PainterImpl.Instruction.Fill(block));
        }

        @Override
        public void every(Painter.Area area, Painter.Operation operation) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

