/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.painter;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.painter.Painter;
import net.minestom.server.instance.painter.PreparedOperation;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

record PainterImpl(List<Instruction> instructions) implements Painter
{
    public PainterImpl {
        instructions = List.copyOf(instructions);
    }

    static PainterImpl paint(Consumer<Painter.ReadableWorld> consumer) {
        WorldImpl world = new WorldImpl();
        consumer.accept(world);
        return new PainterImpl(world.instructions);
    }

    @Override
    public Palette sectionAt(int sectionX, int sectionY, int sectionZ) {
        return PainterImpl.sectionAt(this.instructions, sectionX, sectionY, sectionZ);
    }

    static void applyInstruction(int sectionX, int sectionY, int sectionZ, Palette palette, Point offset, Bounds bounds, Instruction instruction) {
        if (!PainterImpl.sectionRelevant(instruction, sectionX, sectionY, sectionZ, offset)) {
            return;
        }
        int minSectionX = sectionX * 16;
        int maxSectionX = minSectionX + 16;
        int minSectionY = sectionY * 16;
        int maxSectionY = minSectionY + 16;
        int minSectionZ = sectionZ * 16;
        int maxSectionZ = minSectionZ + 16;
        Instruction instruction2 = instruction;
        Objects.requireNonNull(instruction2);
        Instruction instruction3 = instruction2;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instruction.SetBlock.class, Instruction.Cuboid.class, Instruction.Fill.class, Instruction.AreaOperation.class}, (Object)instruction3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Instruction.SetBlock setBlock = (Instruction.SetBlock)instruction3;
                int absX = setBlock.x() + offset.blockX();
                int absY = setBlock.y() + offset.blockY();
                int absZ = setBlock.z() + offset.blockZ();
                if (absX < minSectionX || absX >= maxSectionX || absY < minSectionY || absY >= maxSectionY || absZ < minSectionZ || absZ >= maxSectionZ) {
                    return;
                }
                int localX = ChunkUtils.toSectionRelativeCoordinate(absX);
                int localY = ChunkUtils.toSectionRelativeCoordinate(absY);
                int localZ = ChunkUtils.toSectionRelativeCoordinate(absZ);
                palette.set(localX, localY, localZ, setBlock.block().stateId());
                break;
            }
            case 1: {
                Instruction.Cuboid cuboid = (Instruction.Cuboid)instruction3;
                for (int x = cuboid.min().blockX(); x < cuboid.max().blockX(); ++x) {
                    for (int y = cuboid.min().blockY(); y < cuboid.max().blockY(); ++y) {
                        for (int z = cuboid.min().blockZ(); z < cuboid.max().blockZ(); ++z) {
                            Block block = cuboid.block();
                            if (x < minSectionX || x >= maxSectionX || y < minSectionY || y >= maxSectionY || z < minSectionZ || z >= maxSectionZ) continue;
                            int localX = ChunkUtils.toSectionRelativeCoordinate(x);
                            int localY = ChunkUtils.toSectionRelativeCoordinate(y);
                            int localZ = ChunkUtils.toSectionRelativeCoordinate(z);
                            palette.set(localX, localY, localZ, block.stateId());
                        }
                    }
                }
                break;
            }
            case 2: {
                Instruction.Fill fill = (Instruction.Fill)instruction3;
                assert (bounds != null);
                Vec min = bounds.min();
                Vec max = bounds.max();
                Block block = fill.block();
                for (int x = min.blockX(); x <= max.blockX(); ++x) {
                    for (int y = min.blockY(); y <= max.blockY(); ++y) {
                        for (int z = min.blockZ(); z <= max.blockZ(); ++z) {
                            if (x < minSectionX || x >= maxSectionX || y < minSectionY || y >= maxSectionY || z < minSectionZ || z >= maxSectionZ) continue;
                            int localX = ChunkUtils.toSectionRelativeCoordinate(x);
                            int localY = ChunkUtils.toSectionRelativeCoordinate(y);
                            int localZ = ChunkUtils.toSectionRelativeCoordinate(z);
                            palette.set(localX, localY, localZ, block.stateId());
                        }
                    }
                }
                break;
            }
            case 3: {
                Instruction.AreaOperation areaOperation = (Instruction.AreaOperation)instruction3;
                AreaImpl area = (AreaImpl)areaOperation.area();
                switch (area.type().ordinal()) {
                    case 0: {
                        for (int x = minSectionX; x < maxSectionX; ++x) {
                            for (int y = minSectionY; y < maxSectionY; ++y) {
                                for (int z = minSectionZ; z < maxSectionZ; ++z) {
                                    PainterImpl.applyArea(areaOperation, sectionX, sectionY, sectionZ, new Vec(x, y, z), new Vec(x, y, z), palette);
                                }
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        PainterImpl.applyArea(areaOperation, sectionX, sectionY, sectionZ, new Vec(minSectionX, minSectionY, minSectionZ), new Vec(maxSectionX, maxSectionY, maxSectionZ), palette);
                        break block0;
                    }
                    case 2: {
                        for (int x = minSectionX; x < maxSectionX; ++x) {
                            for (int z = minSectionZ; z < maxSectionZ; ++z) {
                                PainterImpl.applyArea(areaOperation, sectionX, sectionY, sectionZ, new Vec(x, minSectionY, z), new Vec(x, maxSectionY, z), palette);
                            }
                        }
                        break block0;
                    }
                    case 3: {
                        PainterImpl.applyArea(areaOperation, sectionX, sectionY, sectionZ, new Vec(minSectionX, minSectionY, minSectionZ), new Vec(maxSectionX, maxSectionY, maxSectionZ), palette);
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        Point point = (Point)area.object();
                    }
                }
            }
        }
    }

    static void applyArea(Instruction.AreaOperation areaOperation, int sectionX, int sectionY, int sectionZ, Vec start, Vec end, Palette palette) {
        AreaImpl area = (AreaImpl)areaOperation.area();
        PreparedOperation operation = areaOperation.operation();
        Painter.HeightProvider heightProvider = area.heightProvider();
        Painter.PosPredicate ratePredicate = area.ratePredicate();
        int startX = start.blockX();
        int startY = start.blockY();
        int startZ = start.blockZ();
        int endX = end.blockX();
        int endY = end.blockY();
        int endZ = end.blockZ();
        if (ratePredicate != null && !ratePredicate.test(startX, startY, startZ)) {
            return;
        }
        for (Instruction opInstruction : operation.instructions()) {
            Vec sectionOffset;
            Bounds areaBounds;
            if (heightProvider != null) {
                int height = area.heightProvider().test(startX, startZ);
                int minY = Math.min(startY, height);
                int maxY = Math.min(endY, height);
                areaBounds = new Bounds(start.withY(minY), end.withY(maxY));
                sectionOffset = start.withY(maxY);
            } else {
                areaBounds = new Bounds(start, end);
                sectionOffset = start.withY(0.0);
            }
            PainterImpl.applyInstruction(sectionX, sectionY, sectionZ, palette, sectionOffset, areaBounds, opInstruction);
        }
    }

    static Palette sectionAt(List<Instruction> instructions, int sectionX, int sectionY, int sectionZ) {
        Palette palette = Palette.blocks();
        for (Instruction instruction : instructions) {
            PainterImpl.applyInstruction(sectionX, sectionY, sectionZ, palette, Vec.ZERO, null, instruction);
        }
        return palette;
    }

    static boolean sectionRelevant(Instruction instruction, int sectionX, int sectionY, int sectionZ, Point offset) {
        Instruction instruction2 = instruction;
        Objects.requireNonNull(instruction2);
        Instruction instruction3 = instruction2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Instruction.SetBlock.class, Instruction.Cuboid.class, Instruction.Fill.class, Instruction.AreaOperation.class}, (Object)instruction3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Instruction.SetBlock setBlock = (Instruction.SetBlock)instruction3;
                if (ChunkUtils.getChunkCoordinate(setBlock.x() + offset.blockX()) == sectionX && ChunkUtils.getChunkCoordinate(setBlock.y() + offset.blockY()) == sectionY && ChunkUtils.getChunkCoordinate(setBlock.z() + offset.blockZ()) == sectionZ) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Instruction.Cuboid cuboid = (Instruction.Cuboid)instruction3;
                Vec min = cuboid.min();
                Vec max = cuboid.max();
                yield PainterImpl.sectionInBound(min, max, sectionX, sectionY, sectionZ);
            }
            case 2 -> {
                Instruction.Fill ignored = (Instruction.Fill)instruction3;
                yield true;
            }
            case 3 -> {
                Instruction.AreaOperation ignored = (Instruction.AreaOperation)instruction3;
                yield true;
            }
        };
    }

    static boolean sectionInBound(Vec min, Vec max, int sectionX, int sectionY, int sectionZ) {
        int minX = ChunkUtils.getChunkCoordinate(min.blockX());
        int minY = ChunkUtils.getChunkCoordinate(min.blockY());
        int minZ = ChunkUtils.getChunkCoordinate(min.blockZ());
        int maxX = ChunkUtils.getChunkCoordinate(max.blockX());
        int maxY = ChunkUtils.getChunkCoordinate(max.blockY());
        int maxZ = ChunkUtils.getChunkCoordinate(max.blockZ());
        return sectionX >= minX && sectionX <= maxX && sectionY >= minY && sectionY <= maxY && sectionZ >= minZ && sectionZ <= maxZ;
    }

    static final class WorldImpl
    implements Painter.ReadableWorld {
        private final List<Instruction> instructions = new ArrayList<Instruction>();

        WorldImpl() {
        }

        @Override
        public @UnknownNullability Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
            Palette palette = PainterImpl.sectionAt(this.instructions, ChunkUtils.getChunkCoordinate(x), ChunkUtils.getChunkCoordinate(y), ChunkUtils.getChunkCoordinate(z));
            int stateId = palette.get(ChunkUtils.toSectionRelativeCoordinate(x), ChunkUtils.toSectionRelativeCoordinate(y), ChunkUtils.toSectionRelativeCoordinate(z));
            return Block.fromStateId(stateId);
        }

        @Override
        public void setBlock(int x, int y, int z, @NotNull Block block) {
            this.append(new Instruction.SetBlock(x, y, z, block));
        }

        @Override
        public void cuboid(Point min, Point max, Block block) {
            this.append(new Instruction.Cuboid(Vec.fromPoint(min), Vec.fromPoint(max), block));
        }

        @Override
        public void fill(Block block) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void every(Painter.Area area, Painter.Operation operation) {
            PreparedOperation prepared = PreparedOperation.compile(operation);
            if (prepared == null) {
                return;
            }
            this.append(new Instruction.AreaOperation(area, prepared));
        }

        void append(Instruction instruction) {
            this.instructions.add(instruction);
        }
    }

    static sealed interface Instruction {

        public record AreaOperation(Painter.Area area, PreparedOperation operation) implements Instruction
        {
        }

        public record Fill(Block block) implements Instruction
        {
        }

        public record Cuboid(Vec min, Vec max, Block block) implements Instruction
        {
        }

        public record SetBlock(int x, int y, int z, Block block) implements Instruction
        {
        }
    }

    record Bounds(Vec min, Vec max) {
    }

    record AreaImpl(Type type, Object object, Painter.HeightProvider heightProvider, Painter.PosPredicate ratePredicate) implements Painter.Area
    {
        public AreaImpl(Type type, Object object) {
            this(type, object, null, null);
        }

        public AreaImpl(Type type) {
            this(type, null, null, null);
        }

        @Override
        public Painter.Area height(Painter.HeightProvider heightProvider) {
            return new AreaImpl(this.type, this.object, heightProvider, this.ratePredicate);
        }

        @Override
        public Painter.Area rate(Painter.PosPredicate predicate) {
            return new AreaImpl(this.type, this.object, this.heightProvider, predicate);
        }

        static enum Type {
            BLOCK,
            SECTION,
            COLUMN,
            CHUNK,
            REGION,
            RANGE;

        }
    }
}

