/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.painter;

import java.util.function.Consumer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.generator.Generator;
import net.minestom.server.instance.painter.PainterImpl;
import net.minestom.server.instance.palette.Palette;

public interface Painter {
    public static Painter paint(Consumer<ReadableWorld> consumer) {
        return PainterImpl.paint(consumer);
    }

    public Palette sectionAt(int var1, int var2, int var3);

    default public Generator asGenerator() {
        return unit -> {
            Point start = unit.absoluteStart();
            Point end = unit.absoluteEnd();
            int minX = start.chunkX();
            int minY = start.section();
            int minZ = start.chunkZ();
            int maxX = end.chunkX();
            int maxY = end.section();
            int maxZ = end.chunkZ();
            for (int sectionX = minX; sectionX < maxX; ++sectionX) {
                for (int sectionY = minY; sectionY < maxY; ++sectionY) {
                    for (int sectionZ = minZ; sectionZ < maxZ; ++sectionZ) {
                        Palette palette = this.sectionAt(sectionX, sectionY, sectionZ);
                        if (palette.count() == 0) continue;
                        int finalSectionX = sectionX;
                        int finalSectionY = sectionY;
                        int finalSectionZ = sectionZ;
                        palette.getAllPresent((x, y, z, value) -> {
                            int globalX = x + finalSectionX * 16;
                            int globalY = y + finalSectionY * 16;
                            int globalZ = z + finalSectionZ * 16;
                            Block block = Block.fromStateId(value);
                            if (!1.$assertionsDisabled && block == null) {
                                throw new AssertionError();
                            }
                            unit.modifier().setBlock(globalX, globalY, globalZ, block);
                        });
                    }
                }
            }
        };
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    @FunctionalInterface
    public static interface Operation {
        public void apply(World var1);
    }

    @FunctionalInterface
    public static interface HeightProvider {
        public int test(int var1, int var2);
    }

    @FunctionalInterface
    public static interface PosPredicate {
        public boolean test(int var1, int var2, int var3);
    }

    public static interface Area {
        public static Area block() {
            return new PainterImpl.AreaImpl(PainterImpl.AreaImpl.Type.BLOCK);
        }

        public static Area section() {
            return new PainterImpl.AreaImpl(PainterImpl.AreaImpl.Type.SECTION);
        }

        public static Area column() {
            return new PainterImpl.AreaImpl(PainterImpl.AreaImpl.Type.COLUMN);
        }

        public static Area chunk() {
            return new PainterImpl.AreaImpl(PainterImpl.AreaImpl.Type.CHUNK);
        }

        public static Area region() {
            return new PainterImpl.AreaImpl(PainterImpl.AreaImpl.Type.REGION);
        }

        public static Area range(Point range) {
            return new PainterImpl.AreaImpl(PainterImpl.AreaImpl.Type.RANGE, range);
        }

        public Area height(HeightProvider var1);

        public Area rate(PosPredicate var1);
    }

    public static interface ReadableWorld
    extends World,
    Block.Getter {
    }

    public static interface World
    extends Block.Setter {
        default public void cube(Point mid, int size, Block block) {
            Point min = mid.sub((double)size / 2.0, (double)size / 2.0, (double)size / 2.0);
            Point max = mid.add((double)size / 2.0, (double)size / 2.0, (double)size / 2.0);
            this.cuboid(min, max, block);
        }

        public void cuboid(Point var1, Point var2, Block var3);

        public void fill(Block var1);

        public void every(Area var1, Operation var2);
    }
}

