/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.RecipeCategory;
import net.minestom.server.recipe.RecipeType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RecipeSerializers {
    public static final NetworkBuffer.Type<Recipe> RECIPE = new NetworkBuffer.Type<Recipe>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, Recipe shaped) {
            buffer.write(NetworkBuffer.STRING, shaped.id());
            RecipeType recipeType = RecipeSerializers.recipeToType(shaped.data());
            buffer.write(RecipeType.NETWORK_TYPE, recipeType);
            NetworkBuffer.Type<Recipe.Data> serializer = RecipeSerializers.dataSerializer(recipeType);
            if (serializer == null) {
                throw new UnsupportedOperationException("Unrecognized type: " + String.valueOf(recipeType));
            }
            serializer.write(buffer, shaped.data());
        }

        @Override
        public Recipe read(@NotNull NetworkBuffer buffer) {
            String identifier = buffer.read(NetworkBuffer.STRING);
            RecipeType type = buffer.read(RecipeType.NETWORK_TYPE);
            NetworkBuffer.Type<Recipe.Data> serializer = RecipeSerializers.dataSerializer(type);
            if (serializer == null) {
                throw new UnsupportedOperationException("Unrecognized type: " + String.valueOf(type));
            }
            Recipe.Data data = serializer.read(buffer);
            return new Recipe(identifier, data);
        }
    };
    public static final NetworkBuffer.Type<Recipe.Ingredient> INGREDIENT = NetworkBufferTemplate.template(ItemStack.STRICT_NETWORK_TYPE.list(128), Recipe.Ingredient::items, Recipe.Ingredient::new);
    public static final NetworkBuffer.Type<Recipe.Shaped> SHAPED = new NetworkBuffer.Type<Recipe.Shaped>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, Recipe.Shaped shaped) {
            buffer.write(NetworkBuffer.STRING, shaped.group());
            buffer.write(NetworkBuffer.Enum(RecipeCategory.Crafting.class), shaped.category());
            buffer.write(NetworkBuffer.VAR_INT, shaped.width());
            buffer.write(NetworkBuffer.VAR_INT, shaped.height());
            for (Recipe.Ingredient ingredient : shaped.ingredients()) {
                buffer.write(INGREDIENT, ingredient);
            }
            buffer.write(ItemStack.STRICT_NETWORK_TYPE, shaped.result());
            buffer.write(NetworkBuffer.BOOLEAN, shaped.showNotification());
        }

        @Override
        public Recipe.Shaped read(@NotNull NetworkBuffer buffer) {
            String group = buffer.read(NetworkBuffer.STRING);
            RecipeCategory.Crafting category = buffer.read(NetworkBuffer.Enum(RecipeCategory.Crafting.class));
            int width = buffer.read(NetworkBuffer.VAR_INT);
            int height = buffer.read(NetworkBuffer.VAR_INT);
            ArrayList<Recipe.Ingredient> ingredients = new ArrayList<Recipe.Ingredient>();
            for (int slot = 0; slot < width * height; ++slot) {
                ingredients.add(buffer.read(INGREDIENT));
            }
            ItemStack result = buffer.read(ItemStack.STRICT_NETWORK_TYPE);
            boolean showNotification = buffer.read(NetworkBuffer.BOOLEAN);
            return new Recipe.Shaped(group, category, width, height, ingredients, result, showNotification);
        }
    };
    public static final NetworkBuffer.Type<Recipe.Shapeless> SHAPELESS = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Shapeless::group, NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.Shapeless::category, INGREDIENT.list(128), Recipe.Shapeless::ingredients, ItemStack.STRICT_NETWORK_TYPE, Recipe.Shapeless::result, Recipe.Shapeless::new);
    public static final NetworkBuffer.Type<Recipe.Smelting> SMELTING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Smelting::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.Smelting::category, INGREDIENT, Recipe.Smelting::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Smelting::result, NetworkBuffer.FLOAT, Recipe.Smelting::experience, NetworkBuffer.VAR_INT, Recipe.Smelting::cookingTime, Recipe.Smelting::new);
    public static final NetworkBuffer.Type<Recipe.Blasting> BLASTING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Blasting::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.Blasting::category, INGREDIENT, Recipe.Blasting::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Blasting::result, NetworkBuffer.FLOAT, Recipe.Blasting::experience, NetworkBuffer.VAR_INT, Recipe.Blasting::cookingTime, Recipe.Blasting::new);
    public static final NetworkBuffer.Type<Recipe.Smoking> SMOKING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Smoking::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.Smoking::category, INGREDIENT, Recipe.Smoking::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Smoking::result, NetworkBuffer.FLOAT, Recipe.Smoking::experience, NetworkBuffer.VAR_INT, Recipe.Smoking::cookingTime, Recipe.Smoking::new);
    public static final NetworkBuffer.Type<Recipe.CampfireCooking> CAMPFIRE_COOKING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.CampfireCooking::group, NetworkBuffer.Enum(RecipeCategory.Cooking.class), Recipe.CampfireCooking::category, INGREDIENT, Recipe.CampfireCooking::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.CampfireCooking::result, NetworkBuffer.FLOAT, Recipe.CampfireCooking::experience, NetworkBuffer.VAR_INT, Recipe.CampfireCooking::cookingTime, Recipe.CampfireCooking::new);
    public static final NetworkBuffer.Type<Recipe.Stonecutting> STONECUTTING = NetworkBufferTemplate.template(NetworkBuffer.STRING, Recipe.Stonecutting::group, INGREDIENT, Recipe.Stonecutting::ingredient, ItemStack.STRICT_NETWORK_TYPE, Recipe.Stonecutting::result, Recipe.Stonecutting::new);
    public static final NetworkBuffer.Type<Recipe.SmithingTransform> SMITHING_TRANSFORM = NetworkBufferTemplate.template(INGREDIENT, Recipe.SmithingTransform::template, INGREDIENT, Recipe.SmithingTransform::base, INGREDIENT, Recipe.SmithingTransform::addition, ItemStack.STRICT_NETWORK_TYPE, Recipe.SmithingTransform::result, Recipe.SmithingTransform::new);
    public static final NetworkBuffer.Type<Recipe.SmithingTrim> SMITHING_TRIM = NetworkBufferTemplate.template(INGREDIENT, Recipe.SmithingTrim::template, INGREDIENT, Recipe.SmithingTrim::base, INGREDIENT, Recipe.SmithingTrim::addition, Recipe.SmithingTrim::new);
    public static final NetworkBuffer.Type<Recipe.SpecialArmorDye> ARMOR_DYE = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialArmorDye::category, Recipe.SpecialArmorDye::new);
    public static final NetworkBuffer.Type<Recipe.SpecialBookCloning> BOOK_CLONING = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialBookCloning::category, Recipe.SpecialBookCloning::new);
    public static final NetworkBuffer.Type<Recipe.SpecialMapCloning> MAP_CLONING = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialMapCloning::category, Recipe.SpecialMapCloning::new);
    public static final NetworkBuffer.Type<Recipe.SpecialMapExtending> MAP_EXTENDING = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialMapExtending::category, Recipe.SpecialMapExtending::new);
    public static final NetworkBuffer.Type<Recipe.SpecialFireworkRocket> FIREWORK_ROCKET = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialFireworkRocket::category, Recipe.SpecialFireworkRocket::new);
    public static final NetworkBuffer.Type<Recipe.SpecialFireworkStar> FIREWORK_STAR = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialFireworkStar::category, Recipe.SpecialFireworkStar::new);
    public static final NetworkBuffer.Type<Recipe.SpecialFireworkStarFade> FIREWORK_STAR_FADE = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialFireworkStarFade::category, Recipe.SpecialFireworkStarFade::new);
    public static final NetworkBuffer.Type<Recipe.SpecialTippedArrow> TIPPED_ARROW = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialTippedArrow::category, Recipe.SpecialTippedArrow::new);
    public static final NetworkBuffer.Type<Recipe.SpecialBannerDuplicate> BANNER_DUPLICATE = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialBannerDuplicate::category, Recipe.SpecialBannerDuplicate::new);
    public static final NetworkBuffer.Type<Recipe.SpecialShieldDecoration> SHIELD_DECORATION = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialShieldDecoration::category, Recipe.SpecialShieldDecoration::new);
    public static final NetworkBuffer.Type<Recipe.SpecialShulkerBoxColoring> SPECIAL_SHULKER_BOX_COLORING = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialShulkerBoxColoring::category, Recipe.SpecialShulkerBoxColoring::new);
    public static final NetworkBuffer.Type<Recipe.SpecialSuspiciousStew> SUSPICIOUS_STEW = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialSuspiciousStew::category, Recipe.SpecialSuspiciousStew::new);
    public static final NetworkBuffer.Type<Recipe.SpecialRepairItem> REPAIR_ITEM = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.SpecialRepairItem::category, Recipe.SpecialRepairItem::new);
    public static final NetworkBuffer.Type<Recipe.DecoratedPot> DECORATED_POT = NetworkBufferTemplate.template(NetworkBuffer.Enum(RecipeCategory.Crafting.class), Recipe.DecoratedPot::category, Recipe.DecoratedPot::new);

    public static NetworkBuffer.Type<Recipe.Data> dataSerializer(RecipeType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RecipeType.SHAPED -> SHAPED;
            case RecipeType.SHAPELESS -> SHAPELESS;
            case RecipeType.SPECIAL_ARMORDYE -> ARMOR_DYE;
            case RecipeType.SPECIAL_BOOKCLONING -> BOOK_CLONING;
            case RecipeType.SPECIAL_MAPCLONING -> MAP_CLONING;
            case RecipeType.SPECIAL_MAPEXTENDING -> MAP_EXTENDING;
            case RecipeType.SPECIAL_FIREWORK_ROCKET -> FIREWORK_ROCKET;
            case RecipeType.SPECIAL_FIREWORK_STAR -> FIREWORK_STAR;
            case RecipeType.SPECIAL_FIREWORK_STAR_FADE -> FIREWORK_STAR_FADE;
            case RecipeType.SPECIAL_TIPPEDARROW -> TIPPED_ARROW;
            case RecipeType.SPECIAL_BANNERDUPLICATE -> BANNER_DUPLICATE;
            case RecipeType.SPECIAL_SHIELDDECORATION -> SHIELD_DECORATION;
            case RecipeType.SPECIAL_SHULKERBOXCOLORING -> SPECIAL_SHULKER_BOX_COLORING;
            case RecipeType.SPECIAL_SUSPICIOUSSTEW -> SUSPICIOUS_STEW;
            case RecipeType.SPECIAL_REPAIRITEM -> REPAIR_ITEM;
            case RecipeType.SMELTING -> SMELTING;
            case RecipeType.BLASTING -> BLASTING;
            case RecipeType.SMOKING -> SMOKING;
            case RecipeType.CAMPFIRE_COOKING -> CAMPFIRE_COOKING;
            case RecipeType.STONECUTTING -> STONECUTTING;
            case RecipeType.SMITHING_TRANSFORM -> SMITHING_TRANSFORM;
            case RecipeType.SMITHING_TRIM -> SMITHING_TRIM;
            case RecipeType.DECORATED_POT -> DECORATED_POT;
        };
    }

    public static RecipeType recipeToType(Recipe.Data data) {
        Recipe.Data data2 = data;
        Objects.requireNonNull(data2);
        Recipe.Data data3 = data2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Recipe.Shaped.class, Recipe.Shapeless.class, Recipe.Smelting.class, Recipe.Blasting.class, Recipe.Smoking.class, Recipe.CampfireCooking.class, Recipe.Stonecutting.class, Recipe.SmithingTransform.class, Recipe.SmithingTrim.class, Recipe.SpecialArmorDye.class, Recipe.SpecialBannerDuplicate.class, Recipe.SpecialBookCloning.class, Recipe.DecoratedPot.class, Recipe.SpecialFireworkRocket.class, Recipe.SpecialFireworkStar.class, Recipe.SpecialFireworkStarFade.class, Recipe.SpecialMapCloning.class, Recipe.SpecialMapExtending.class, Recipe.SpecialRepairItem.class, Recipe.SpecialShieldDecoration.class, Recipe.SpecialShulkerBoxColoring.class, Recipe.SpecialSuspiciousStew.class, Recipe.SpecialTippedArrow.class}, (Object)data3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Recipe.Shaped ignored = (Recipe.Shaped)data3;
                yield RecipeType.SHAPED;
            }
            case 1 -> {
                Recipe.Shapeless ignored = (Recipe.Shapeless)data3;
                yield RecipeType.SHAPELESS;
            }
            case 2 -> {
                Recipe.Smelting ignored = (Recipe.Smelting)data3;
                yield RecipeType.SMELTING;
            }
            case 3 -> {
                Recipe.Blasting ignored = (Recipe.Blasting)data3;
                yield RecipeType.BLASTING;
            }
            case 4 -> {
                Recipe.Smoking ignored = (Recipe.Smoking)data3;
                yield RecipeType.SMOKING;
            }
            case 5 -> {
                Recipe.CampfireCooking ignored = (Recipe.CampfireCooking)data3;
                yield RecipeType.CAMPFIRE_COOKING;
            }
            case 6 -> {
                Recipe.Stonecutting ignored = (Recipe.Stonecutting)data3;
                yield RecipeType.STONECUTTING;
            }
            case 7 -> {
                Recipe.SmithingTransform ignored = (Recipe.SmithingTransform)data3;
                yield RecipeType.SMITHING_TRANSFORM;
            }
            case 8 -> {
                Recipe.SmithingTrim ignored = (Recipe.SmithingTrim)data3;
                yield RecipeType.SMITHING_TRIM;
            }
            case 9 -> {
                Recipe.SpecialArmorDye ignored = (Recipe.SpecialArmorDye)data3;
                yield RecipeType.SPECIAL_ARMORDYE;
            }
            case 10 -> {
                Recipe.SpecialBannerDuplicate ignored = (Recipe.SpecialBannerDuplicate)data3;
                yield RecipeType.SPECIAL_BANNERDUPLICATE;
            }
            case 11 -> {
                Recipe.SpecialBookCloning ignored = (Recipe.SpecialBookCloning)data3;
                yield RecipeType.SPECIAL_BOOKCLONING;
            }
            case 12 -> {
                Recipe.DecoratedPot ignored = (Recipe.DecoratedPot)data3;
                yield RecipeType.DECORATED_POT;
            }
            case 13 -> {
                Recipe.SpecialFireworkRocket ignored = (Recipe.SpecialFireworkRocket)data3;
                yield RecipeType.SPECIAL_FIREWORK_ROCKET;
            }
            case 14 -> {
                Recipe.SpecialFireworkStar ignored = (Recipe.SpecialFireworkStar)data3;
                yield RecipeType.SPECIAL_FIREWORK_STAR;
            }
            case 15 -> {
                Recipe.SpecialFireworkStarFade ignored = (Recipe.SpecialFireworkStarFade)data3;
                yield RecipeType.SPECIAL_FIREWORK_STAR_FADE;
            }
            case 16 -> {
                Recipe.SpecialMapCloning ignored = (Recipe.SpecialMapCloning)data3;
                yield RecipeType.SPECIAL_MAPCLONING;
            }
            case 17 -> {
                Recipe.SpecialMapExtending ignored = (Recipe.SpecialMapExtending)data3;
                yield RecipeType.SPECIAL_MAPEXTENDING;
            }
            case 18 -> {
                Recipe.SpecialRepairItem ignored = (Recipe.SpecialRepairItem)data3;
                yield RecipeType.SPECIAL_REPAIRITEM;
            }
            case 19 -> {
                Recipe.SpecialShieldDecoration ignored = (Recipe.SpecialShieldDecoration)data3;
                yield RecipeType.SPECIAL_SHIELDDECORATION;
            }
            case 20 -> {
                Recipe.SpecialShulkerBoxColoring ignored = (Recipe.SpecialShulkerBoxColoring)data3;
                yield RecipeType.SPECIAL_SHULKERBOXCOLORING;
            }
            case 21 -> {
                Recipe.SpecialSuspiciousStew ignored = (Recipe.SpecialSuspiciousStew)data3;
                yield RecipeType.SPECIAL_SUSPICIOUSSTEW;
            }
            case 22 -> {
                Recipe.SpecialTippedArrow ignored = (Recipe.SpecialTippedArrow)data3;
                yield RecipeType.SPECIAL_TIPPEDARROW;
            }
        };
    }
}

