/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.recipe.Recipe;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class RecipeCompute {
    @Nullable
    public static CraftResult searchCraft(List<Recipe> recipes, int width, int height, ItemStack[] items) {
        for (Recipe recipe : recipes) {
            CraftResult result;
            Recipe.Data data;
            Objects.requireNonNull(recipe.data());
            int n = 0;
            if ((result = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Recipe.Shaped.class, Recipe.Shapeless.class}, (Object)data, n)) {
                case 0 -> {
                    Recipe.Shaped shaped = (Recipe.Shaped)data;
                    yield RecipeCompute.searchShaped(shaped, width, height, items);
                }
                case 1 -> {
                    Recipe.Shapeless shapeless = (Recipe.Shapeless)data;
                    yield RecipeCompute.searchShapeless(shapeless, items);
                }
                default -> null;
            })) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private static CraftResult searchShaped(Recipe.Shaped recipe, int width, int height, ItemStack[] items) {
        int y;
        int x;
        if (width < recipe.width() || height < recipe.height()) {
            return null;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                ItemStack item = items[x + y * width];
                if (item.isAir()) continue;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        if (maxX - minX + 1 > recipe.width() || maxY - minY + 1 > recipe.height()) {
            return null;
        }
        for (x = 0; x <= width - recipe.width(); ++x) {
            for (y = 0; y <= height - recipe.height(); ++y) {
                boolean found = true;
                for (int recipeX = 0; recipeX < recipe.width(); ++recipeX) {
                    for (int recipeY = 0; recipeY < recipe.height(); ++recipeY) {
                        boolean validIngredient = false;
                        int ingredientIndex = recipeX + recipeY * recipe.width();
                        Recipe.Ingredient ingredient = recipe.ingredients().get(ingredientIndex);
                        ItemStack item = items[x + recipeX + (y + recipeY) * width];
                        if (ingredient.items().isEmpty() && item.isAir()) {
                            validIngredient = true;
                        } else {
                            for (ItemStack ingredientItem : ingredient.items()) {
                                if (!ingredientItem.isSimilar(item)) continue;
                                validIngredient = true;
                                break;
                            }
                        }
                        if (validIngredient) continue;
                        found = false;
                        break;
                    }
                    if (!found) break;
                }
                if (!found) continue;
                return new CraftResult(recipe.result(), RecipeCompute.possibleConsume(items));
            }
        }
        return null;
    }

    @Nullable
    private static CraftResult searchShapeless(Recipe.Shapeless recipe, ItemStack[] items) {
        HashMap<Material, Integer> materials = new HashMap<Material, Integer>();
        for (ItemStack item : items) {
            if (item.isAir()) continue;
            materials.put(item.material(), materials.getOrDefault(item.material(), 0) + 1);
        }
        if (materials.isEmpty()) {
            return null;
        }
        for (Recipe.Ingredient ingredient : recipe.ingredients()) {
            boolean success = false;
            for (ItemStack item : ingredient.items()) {
                Material material = item.material();
                int occurrences = materials.getOrDefault(material, 0);
                if (occurrences == 0) continue;
                int reduced = occurrences - 1;
                if (reduced > 0) {
                    materials.put(material, reduced);
                } else {
                    materials.remove(material);
                }
                success = true;
                break;
            }
            if (success) continue;
            return null;
        }
        if (!materials.isEmpty()) {
            return null;
        }
        return new CraftResult(recipe.result(), RecipeCompute.possibleConsume(items));
    }

    private static int possibleConsume(ItemStack[] items) {
        int smallestSize = Integer.MAX_VALUE;
        for (ItemStack item : items) {
            if (item.isAir() || item.amount() >= smallestSize) continue;
            smallestSize = item.amount();
        }
        return smallestSize;
    }

    public record CraftResult(ItemStack item, int consumeAbility) {
    }
}

