/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.util.List;
import java.util.UUID;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GameProfile(@NotNull UUID uuid, @NotNull String name, @NotNull @NotNull List<@NotNull Property> properties) {
    public static final int MAX_PROPERTIES = 1024;
    public static final NetworkBuffer.Type<GameProfile> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.UUID, GameProfile::uuid, NetworkBuffer.STRING, GameProfile::name, Property.SERIALIZER.list(1024), GameProfile::properties, GameProfile::new);

    public GameProfile(@NotNull UUID uuid, @NotNull String name, @NotNull List<Property> properties) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        if (name.length() > 16) {
            throw new IllegalArgumentException("Name length cannot be greater than 16 characters");
        }
        properties = List.copyOf(properties);
    }

    public record Property(@NotNull String name, @NotNull String value, @Nullable String signature) {
        public static final NetworkBuffer.Type<Property> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, Property::name, NetworkBuffer.STRING, Property::value, NetworkBuffer.STRING.optional(), Property::signature, Property::new);

        public Property(@NotNull String name, @NotNull String value) {
            this(name, value, null);
        }
    }
}

