/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.util.Locale;
import java.util.Objects;
import net.minestom.server.ServerFlag;
import net.minestom.server.message.ChatMessageType;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.MathUtils;

public record ClientSettings(Locale locale, byte viewDistance, ChatMessageType chatMessageType, boolean chatColors, byte displayedSkinParts, MainHand mainHand, boolean enableTextFiltering, boolean allowServerListings) {
    public static ClientSettings DEFAULT = new ClientSettings(Locale.US, (byte)ServerFlag.CHUNK_VIEW_DISTANCE, ChatMessageType.FULL, true, 127, MainHand.RIGHT, true, true);
    private static final NetworkBuffer.Type<Locale> LOCALE_SERIALIZER = NetworkBuffer.STRING.transform(s -> {
        String locale = s.replace("_", "-");
        return Locale.forLanguageTag(locale);
    }, Locale::toLanguageTag);
    public static final NetworkBuffer.Type<ClientSettings> NETWORK_TYPE = NetworkBufferTemplate.template(LOCALE_SERIALIZER, ClientSettings::locale, NetworkBuffer.BYTE, ClientSettings::viewDistance, NetworkBuffer.Enum(ChatMessageType.class), ClientSettings::chatMessageType, NetworkBuffer.BOOLEAN, ClientSettings::chatColors, NetworkBuffer.BYTE, ClientSettings::displayedSkinParts, NetworkBuffer.Enum(MainHand.class), ClientSettings::mainHand, NetworkBuffer.BOOLEAN, ClientSettings::enableTextFiltering, NetworkBuffer.BOOLEAN, ClientSettings::allowServerListings, ClientSettings::new);

    public ClientSettings {
        Objects.requireNonNull(locale);
        viewDistance = (byte)MathUtils.clamp(viewDistance, 2, 32);
        Objects.requireNonNull(chatMessageType);
        Objects.requireNonNull(mainHand);
    }

    public int effectiveViewDistance() {
        return Math.min(this.viewDistance(), ServerFlag.CHUNK_VIEW_DISTANCE);
    }

    public static enum MainHand {
        LEFT,
        RIGHT;

    }
}

