/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public record UnlockRecipesPacket(int mode, boolean craftingRecipeBookOpen, boolean craftingRecipeBookFilterActive, boolean smeltingRecipeBookOpen, boolean smeltingRecipeBookFilterActive, boolean blastFurnaceRecipeBookOpen, boolean blastFurnaceRecipeBookFilterActive, boolean smokerRecipeBookOpen, boolean smokerRecipeBookFilterActive, @NotNull List<String> recipeIds, @UnknownNullability List<String> initRecipeIds) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<UnlockRecipesPacket> SERIALIZER = new NetworkBuffer.Type<UnlockRecipesPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, UnlockRecipesPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.mode);
            buffer.write(NetworkBuffer.BOOLEAN, value.craftingRecipeBookOpen);
            buffer.write(NetworkBuffer.BOOLEAN, value.craftingRecipeBookFilterActive);
            buffer.write(NetworkBuffer.BOOLEAN, value.smeltingRecipeBookOpen);
            buffer.write(NetworkBuffer.BOOLEAN, value.smeltingRecipeBookFilterActive);
            buffer.write(NetworkBuffer.BOOLEAN, value.blastFurnaceRecipeBookOpen);
            buffer.write(NetworkBuffer.BOOLEAN, value.blastFurnaceRecipeBookFilterActive);
            buffer.write(NetworkBuffer.BOOLEAN, value.smokerRecipeBookOpen);
            buffer.write(NetworkBuffer.BOOLEAN, value.smokerRecipeBookFilterActive);
            buffer.write(NetworkBuffer.STRING.list(), value.recipeIds);
            if (value.mode == 0) {
                buffer.write(NetworkBuffer.STRING.list(), value.initRecipeIds);
            }
        }

        @Override
        public UnlockRecipesPacket read(@NotNull NetworkBuffer buffer) {
            Integer mode = buffer.read(NetworkBuffer.VAR_INT);
            Boolean craftingRecipeBookOpen = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean craftingRecipeBookFilterActive = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean smeltingRecipeBookOpen = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean smeltingRecipeBookFilterActive = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean blastFurnaceRecipeBookOpen = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean blastFurnaceRecipeBookFilterActive = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean smokerRecipeBookOpen = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean smokerRecipeBookFilterActive = buffer.read(NetworkBuffer.BOOLEAN);
            List<String> recipeIds = buffer.read(NetworkBuffer.STRING.list(Short.MAX_VALUE));
            List<String> initRecipeIds = mode == 0 ? buffer.read(NetworkBuffer.STRING.list(Short.MAX_VALUE)) : null;
            return new UnlockRecipesPacket(mode, craftingRecipeBookOpen, craftingRecipeBookFilterActive, smeltingRecipeBookOpen, smeltingRecipeBookFilterActive, blastFurnaceRecipeBookOpen, blastFurnaceRecipeBookFilterActive, smokerRecipeBookOpen, smokerRecipeBookFilterActive, recipeIds, initRecipeIds);
        }
    };

    public UnlockRecipesPacket(int mode, boolean craftingRecipeBookOpen, boolean craftingRecipeBookFilterActive, boolean smeltingRecipeBookOpen, boolean smeltingRecipeBookFilterActive, boolean blastFurnaceRecipeBookOpen, boolean blastFurnaceRecipeBookFilterActive, boolean smokerRecipeBookOpen, boolean smokerRecipeBookFilterActive, @NotNull List<String> recipeIds, @UnknownNullability List<String> initRecipeIds) {
        recipeIds = List.copyOf(recipeIds);
        if (initRecipeIds != null) {
            initRecipeIds = List.copyOf(initRecipeIds);
        }
    }
}

