/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record SetSlotPacket(byte windowId, int stateId, short slot, @NotNull ItemStack itemStack) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final NetworkBuffer.Type<SetSlotPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.BYTE, SetSlotPacket::windowId, NetworkBuffer.VAR_INT, SetSlotPacket::stateId, NetworkBuffer.SHORT, SetSlotPacket::slot, ItemStack.NETWORK_TYPE, SetSlotPacket::itemStack, SetSlotPacket::new);

    @Override
    @NotNull
    public Collection<Component> components() {
        Component itemName;
        ArrayList<Component> components = new ArrayList<Component>(this.itemStack.get(ItemComponent.LORE, List.of()));
        Component displayName = this.itemStack.get(ItemComponent.CUSTOM_NAME);
        if (displayName != null) {
            components.add(displayName);
        }
        if ((itemName = this.itemStack.get(ItemComponent.ITEM_NAME)) != null) {
            components.add(itemName);
        }
        return List.copyOf(components);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new SetSlotPacket(this.windowId, this.stateId, this.slot, this.itemStack.with(ItemComponent.CUSTOM_NAME, operator).with(ItemComponent.ITEM_NAME, operator).with(ItemComponent.LORE, lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        }));
    }

    @NotNull
    public static SetSlotPacket createCursorPacket(@NotNull ItemStack cursorItem) {
        return new SetSlotPacket(-1, 0, -1, cursorItem);
    }
}

