/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.particle.Particle;
import net.minestom.server.sound.SoundEvent;
import org.jetbrains.annotations.NotNull;

public record ExplosionPacket(double x, double y, double z, float radius, byte @NotNull [] records, float playerMotionX, float playerMotionY, float playerMotionZ, @NotNull BlockInteraction blockInteraction, int smallParticleId, byte @NotNull [] smallParticleData, int largeParticleId, byte @NotNull [] largeParticleData, @NotNull SoundEvent sound) implements ServerPacket.Play
{
    public static final SoundEvent DEFAULT_SOUND = SoundEvent.ENTITY_GENERIC_EXPLODE;
    public static final NetworkBuffer.Type<ExplosionPacket> SERIALIZER = new NetworkBuffer.Type<ExplosionPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, ExplosionPacket value) {
            buffer.write(NetworkBuffer.DOUBLE, value.x);
            buffer.write(NetworkBuffer.DOUBLE, value.y);
            buffer.write(NetworkBuffer.DOUBLE, value.z);
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.radius));
            buffer.write(NetworkBuffer.VAR_INT, value.records.length / 3);
            buffer.write(NetworkBuffer.RAW_BYTES, value.records);
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.playerMotionX));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.playerMotionY));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.playerMotionZ));
            buffer.write(NetworkBuffer.VAR_INT, value.blockInteraction.ordinal());
            buffer.write(NetworkBuffer.VAR_INT, value.smallParticleId);
            buffer.write(NetworkBuffer.RAW_BYTES, value.smallParticleData);
            buffer.write(NetworkBuffer.VAR_INT, value.largeParticleId);
            buffer.write(NetworkBuffer.RAW_BYTES, value.largeParticleData);
            buffer.write(SoundEvent.NETWORK_TYPE, value.sound);
        }

        @Override
        public ExplosionPacket read(@NotNull NetworkBuffer buffer) {
            double x = buffer.read(NetworkBuffer.DOUBLE);
            double y = buffer.read(NetworkBuffer.DOUBLE);
            double z = buffer.read(NetworkBuffer.DOUBLE);
            float radius = buffer.read(NetworkBuffer.FLOAT).floatValue();
            byte[] records = buffer.read(NetworkBuffer.FixedRawBytes(buffer.read(NetworkBuffer.VAR_INT) * 3));
            float playerMotionX = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float playerMotionY = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float playerMotionZ = buffer.read(NetworkBuffer.FLOAT).floatValue();
            BlockInteraction blockInteraction = buffer.read(NetworkBuffer.Enum(BlockInteraction.class));
            int smallParticleId = buffer.read(NetworkBuffer.VAR_INT);
            byte[] smallParticleData = ExplosionPacket.readParticleData(buffer, Particle.fromId(smallParticleId));
            int largeParticleId = buffer.read(NetworkBuffer.VAR_INT);
            byte[] largeParticleData = ExplosionPacket.readParticleData(buffer, Particle.fromId(largeParticleId));
            SoundEvent sound = buffer.read(SoundEvent.NETWORK_TYPE);
            return new ExplosionPacket(x, y, z, radius, records, playerMotionX, playerMotionY, playerMotionZ, blockInteraction, smallParticleId, smallParticleData, largeParticleId, largeParticleData, sound);
        }
    };

    public ExplosionPacket(double x, double y, double z, float radius, byte @NotNull [] records, float playerMotionX, float playerMotionY, float playerMotionZ) {
        this(x, y, z, radius, records, playerMotionX, playerMotionY, playerMotionZ, BlockInteraction.DESTROY, Particle.EXPLOSION.id(), new byte[0], Particle.EXPLOSION_EMITTER.id(), new byte[0], DEFAULT_SOUND);
    }

    private static byte @NotNull [] readParticleData(@NotNull NetworkBuffer reader, Particle particle) {
        return NetworkBuffer.makeArray(buffer -> {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (!particle.equals(Particle.BLOCK) && !particle.equals(Particle.BLOCK_MARKER) && !particle.equals(Particle.FALLING_DUST) && !particle.equals(Particle.SHRIEK)) break block2;
                                    buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                    break block3;
                                }
                                if (!particle.equals(Particle.VIBRATION)) break block4;
                                buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                buffer.write(NetworkBuffer.BLOCK_POSITION, reader.read(NetworkBuffer.BLOCK_POSITION));
                                buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                                buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                break block3;
                            }
                            if (!particle.equals(Particle.SCULK_CHARGE)) break block5;
                            buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                            break block3;
                        }
                        if (!particle.equals(Particle.ITEM)) break block6;
                        buffer.write(ItemStack.NETWORK_TYPE, reader.read(ItemStack.NETWORK_TYPE));
                        break block3;
                    }
                    if (!particle.equals(Particle.DUST_COLOR_TRANSITION)) break block7;
                    for (int i = 0; i < 7; ++i) {
                        buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                    }
                    break block3;
                }
                if (!particle.equals(Particle.DUST)) break block3;
                for (int i = 0; i < 4; ++i) {
                    buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                }
            }
        });
    }

    public static enum BlockInteraction {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY,
        TRIGGER_BLOCK;

    }
}

