/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record EntityTeleportPacket(int entityId, Pos position, boolean onGround) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<EntityTeleportPacket> SERIALIZER = new NetworkBuffer.Type<EntityTeleportPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, @NotNull EntityTeleportPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            buffer.write(NetworkBuffer.DOUBLE, value.position.x());
            buffer.write(NetworkBuffer.DOUBLE, value.position.y());
            buffer.write(NetworkBuffer.DOUBLE, value.position.z());
            buffer.write(NetworkBuffer.BYTE, (byte)(value.position.yaw() * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BYTE, (byte)(value.position.pitch() * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BOOLEAN, value.onGround);
        }

        @Override
        @NotNull
        public EntityTeleportPacket read(@NotNull NetworkBuffer buffer) {
            return new EntityTeleportPacket(buffer.read(NetworkBuffer.VAR_INT), new Pos(buffer.read(NetworkBuffer.DOUBLE), buffer.read(NetworkBuffer.DOUBLE), buffer.read(NetworkBuffer.DOUBLE), (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f), buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
}

