/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.security.Key;
import java.security.PublicKey;
import java.time.Instant;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.DataFormatException;
import javax.crypto.Cipher;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.entity.EntityPose;
import net.minestom.server.network.ComponentNetworkBufferTypeImpl;
import net.minestom.server.network.NetworkBufferImpl;
import net.minestom.server.network.NetworkBufferTypeImpl;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.crypto.KeyUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface NetworkBuffer
permits NetworkBufferImpl {
    public static final Type<Unit> UNIT = new NetworkBufferTypeImpl.UnitType();
    public static final Type<Boolean> BOOLEAN = new NetworkBufferTypeImpl.BooleanType();
    public static final Type<Byte> BYTE = new NetworkBufferTypeImpl.ByteType();
    public static final Type<Short> SHORT = new NetworkBufferTypeImpl.ShortType();
    public static final Type<Integer> UNSIGNED_SHORT = new NetworkBufferTypeImpl.UnsignedShortType();
    public static final Type<Integer> INT = new NetworkBufferTypeImpl.IntType();
    public static final Type<Long> LONG = new NetworkBufferTypeImpl.LongType();
    public static final Type<Float> FLOAT = new NetworkBufferTypeImpl.FloatType();
    public static final Type<Double> DOUBLE = new NetworkBufferTypeImpl.DoubleType();
    public static final Type<Integer> VAR_INT = new NetworkBufferTypeImpl.VarIntType();
    public static final Type<Integer> VAR_INT_3 = new NetworkBufferTypeImpl.VarInt3Type();
    public static final Type<Long> VAR_LONG = new NetworkBufferTypeImpl.VarLongType();
    public static final Type<byte[]> RAW_BYTES = new NetworkBufferTypeImpl.RawBytesType(-1);
    public static final Type<String> STRING = new NetworkBufferTypeImpl.StringType();
    public static final Type<String> STRING_TERMINATED = new NetworkBufferTypeImpl.StringTerminatedType();
    public static final Type<BinaryTag> NBT = new NetworkBufferTypeImpl.NbtType();
    public static final Type<CompoundBinaryTag> NBT_COMPOUND = new NetworkBufferTypeImpl.NbtType();
    public static final Type<Point> BLOCK_POSITION = new NetworkBufferTypeImpl.BlockPositionType();
    public static final Type<Component> COMPONENT = new ComponentNetworkBufferTypeImpl();
    public static final Type<Component> JSON_COMPONENT = new NetworkBufferTypeImpl.JsonComponentType();
    public static final Type<UUID> UUID = new NetworkBufferTypeImpl.UUIDType();
    public static final Type<Pos> POS = new NetworkBufferTypeImpl.PosType();
    public static final Type<byte[]> BYTE_ARRAY = new NetworkBufferTypeImpl.ByteArrayType();
    public static final Type<long[]> LONG_ARRAY = new NetworkBufferTypeImpl.LongArrayType();
    public static final Type<int[]> VAR_INT_ARRAY = new NetworkBufferTypeImpl.VarIntArrayType();
    public static final Type<long[]> VAR_LONG_ARRAY = new NetworkBufferTypeImpl.VarLongArrayType();
    public static final Type<BitSet> BITSET = LONG_ARRAY.transform(BitSet::valueOf, BitSet::toLongArray);
    public static final Type<Instant> INSTANT_MS = LONG.transform(Instant::ofEpochMilli, Instant::toEpochMilli);
    public static final Type<PublicKey> PUBLIC_KEY = BYTE_ARRAY.transform(KeyUtils::publicRSAKeyFrom, Key::getEncoded);
    public static final Type<int[]> VILLAGER_DATA = new NetworkBufferTypeImpl.VillagerDataType();
    public static final Type<Point> VECTOR3 = new NetworkBufferTypeImpl.Vector3Type();
    public static final Type<Point> VECTOR3D = new NetworkBufferTypeImpl.Vector3DType();
    public static final Type<Point> VECTOR3B = new NetworkBufferTypeImpl.Vector3BType();
    public static final Type<float[]> QUATERNION = new NetworkBufferTypeImpl.QuaternionType();
    public static final Type<@Nullable Component> OPT_CHAT = COMPONENT.optional();
    public static final Type<@Nullable Point> OPT_BLOCK_POSITION = BLOCK_POSITION.optional();
    public static final Type<@Nullable UUID> OPT_UUID = UUID.optional();
    public static final Type<Direction> DIRECTION = NetworkBuffer.Enum(Direction.class);
    public static final Type<EntityPose> POSE = NetworkBuffer.Enum(EntityPose.class);

    @NotNull
    public static <T extends ProtocolObject> Type<DynamicRegistry.Key<T>> RegistryKey(@NotNull Function<Registries, DynamicRegistry<T>> selector) {
        return new NetworkBufferTypeImpl.RegistryTypeType<T>(selector);
    }

    @NotNull
    public static <E extends Enum<E>> Type<E> Enum(@NotNull Class<E> enumClass) {
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        return VAR_INT.transform(integer -> values[integer], Enum::ordinal);
    }

    @NotNull
    public static <E extends Enum<E>> Type<EnumSet<E>> EnumSet(@NotNull Class<E> enumClass) {
        return new NetworkBufferTypeImpl.EnumSetType(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    @NotNull
    public static Type<BitSet> FixedBitSet(int length) {
        return new NetworkBufferTypeImpl.FixedBitSetType(length);
    }

    @NotNull
    public static Type<byte[]> FixedRawBytes(int length) {
        return new NetworkBufferTypeImpl.RawBytesType(length);
    }

    @NotNull
    public static <T> Type<T> Lazy(@NotNull @NotNull Supplier<@NotNull Type<T>> supplier) {
        return new NetworkBufferTypeImpl.LazyType<T>(supplier);
    }

    public <T> void write(@NotNull Type<T> var1, @UnknownNullability T var2) throws IndexOutOfBoundsException;

    public <T> @UnknownNullability T read(@NotNull Type<T> var1) throws IndexOutOfBoundsException;

    public <T> void writeAt(long var1, @NotNull Type<T> var3, @UnknownNullability T var4) throws IndexOutOfBoundsException;

    public <T> @UnknownNullability T readAt(long var1, @NotNull Type<T> var3) throws IndexOutOfBoundsException;

    public void copyTo(long var1, byte @NotNull [] var3, long var4, long var6);

    public byte @NotNull [] extractBytes(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> var1);

    @NotNull
    public NetworkBuffer clear();

    public long writeIndex();

    public long readIndex();

    @NotNull
    public NetworkBuffer writeIndex(long var1);

    @NotNull
    public NetworkBuffer readIndex(long var1);

    @NotNull
    public NetworkBuffer index(long var1, long var3);

    public long advanceWrite(long var1);

    public long advanceRead(long var1);

    public long readableBytes();

    public long writableBytes();

    public long capacity();

    public void readOnly();

    public boolean isReadOnly();

    public void resize(long var1);

    public void ensureWritable(long var1);

    public void compact();

    public NetworkBuffer copy(long var1, long var3, long var5, long var7);

    default public NetworkBuffer copy(long index, long length) {
        return this.copy(index, length, this.readIndex(), this.writeIndex());
    }

    public int readChannel(ReadableByteChannel var1) throws IOException;

    public boolean writeChannel(SocketChannel var1) throws IOException;

    public void cipher(Cipher var1, long var2, long var4);

    public long compress(long var1, long var3, NetworkBuffer var5);

    public long decompress(long var1, long var3, NetworkBuffer var5) throws DataFormatException;

    @Nullable
    public Registries registries();

    @NotNull
    public static Builder builder(long size) {
        return new NetworkBufferImpl.Builder(size);
    }

    @NotNull
    public static NetworkBuffer staticBuffer(long size, Registries registries) {
        return NetworkBuffer.builder(size).registry(registries).build();
    }

    @NotNull
    public static NetworkBuffer staticBuffer(long size) {
        return NetworkBuffer.staticBuffer(size, null);
    }

    @NotNull
    public static NetworkBuffer resizableBuffer(long initialSize, Registries registries) {
        return NetworkBuffer.builder(initialSize).autoResize(AutoResize.DOUBLE).registry(registries).build();
    }

    @NotNull
    public static NetworkBuffer resizableBuffer(int initialSize) {
        return NetworkBuffer.resizableBuffer(initialSize, null);
    }

    @NotNull
    public static NetworkBuffer resizableBuffer(Registries registries) {
        return NetworkBuffer.resizableBuffer(256L, registries);
    }

    @NotNull
    public static NetworkBuffer resizableBuffer() {
        return NetworkBuffer.resizableBuffer(null);
    }

    @NotNull
    public static NetworkBuffer wrap(byte @NotNull [] bytes, int readIndex, int writeIndex, @Nullable Registries registries) {
        return NetworkBufferImpl.wrap(bytes, (long)readIndex, (long)writeIndex, registries);
    }

    @NotNull
    public static NetworkBuffer wrap(byte @NotNull [] bytes, int readIndex, int writeIndex) {
        return NetworkBuffer.wrap(bytes, readIndex, writeIndex, null);
    }

    public static byte[] makeArray(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> writing, @Nullable Registries registries) {
        NetworkBuffer buffer = NetworkBuffer.resizableBuffer(256L, registries);
        writing.accept(buffer);
        return buffer.read(RAW_BYTES);
    }

    public static byte[] makeArray(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> writing) {
        return NetworkBuffer.makeArray(writing, null);
    }

    public static <T> byte[] makeArray(@NotNull Type<T> type, @NotNull T value, @Nullable Registries registries) {
        return NetworkBuffer.makeArray((NetworkBuffer buffer) -> buffer.write(type, value), registries);
    }

    public static <T> byte[] makeArray(@NotNull Type<T> type, @NotNull T value) {
        return NetworkBuffer.makeArray(type, value, null);
    }

    public static void copy(NetworkBuffer srcBuffer, long srcOffset, NetworkBuffer dstBuffer, long dstOffset, long length) {
        NetworkBufferImpl.copy(srcBuffer, srcOffset, dstBuffer, dstOffset, length);
    }

    public static boolean equals(NetworkBuffer buffer1, NetworkBuffer buffer2) {
        return NetworkBufferImpl.equals(buffer1, buffer2);
    }

    public static interface Type<T> {
        public void write(@NotNull NetworkBuffer var1, T var2);

        public T read(@NotNull NetworkBuffer var1);

        default public long sizeOf(@NotNull T value, @Nullable Registries registries) {
            return NetworkBufferTypeImpl.sizeOf(this, value, registries);
        }

        default public long sizeOf(@NotNull T value) {
            return this.sizeOf(value, null);
        }

        @NotNull
        default public <S> Type<S> transform(@NotNull Function<T, S> to, @NotNull Function<S, T> from) {
            return new NetworkBufferTypeImpl.TransformType<T, S>(this, to, from);
        }

        @NotNull
        default public <V> Type<Map<T, V>> mapValue(@NotNull Type<V> valueType, int maxSize) {
            return new NetworkBufferTypeImpl.MapType(this, valueType, maxSize);
        }

        @NotNull
        default public <V> Type<Map<T, V>> mapValue(@NotNull Type<V> valueType) {
            return this.mapValue(valueType, Integer.MAX_VALUE);
        }

        @NotNull
        default public Type<List<T>> list(int maxSize) {
            return new NetworkBufferTypeImpl.ListType(this, maxSize);
        }

        @NotNull
        default public Type<List<T>> list() {
            return this.list(Integer.MAX_VALUE);
        }

        @NotNull
        default public Type<T> optional() {
            return new NetworkBufferTypeImpl.OptionalType(this);
        }
    }

    public static sealed interface Builder
    permits NetworkBufferImpl.Builder {
        @NotNull
        public Builder autoResize(@Nullable AutoResize var1);

        @NotNull
        public Builder registry(@Nullable Registries var1);

        @NotNull
        public NetworkBuffer build();
    }

    @FunctionalInterface
    public static interface AutoResize {
        public static final AutoResize DOUBLE = (capacity, targetSize) -> Math.max(capacity * 2L, targetSize);

        public long resize(long var1, long var3);
    }
}

