/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.AsyncPlayerConfigurationEvent;
import net.minestom.server.event.player.AsyncPlayerPreLoginEvent;
import net.minestom.server.instance.Instance;
import net.minestom.server.listener.preplay.LoginListener;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.PlayerProvider;
import net.minestom.server.network.UuidProvider;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.common.KeepAlivePacket;
import net.minestom.server.network.packet.server.common.PluginMessagePacket;
import net.minestom.server.network.packet.server.common.TagsPacket;
import net.minestom.server.network.packet.server.configuration.FinishConfigurationPacket;
import net.minestom.server.network.packet.server.configuration.ResetChatPacket;
import net.minestom.server.network.packet.server.configuration.SelectKnownPacksPacket;
import net.minestom.server.network.packet.server.configuration.UpdateEnabledFeaturesPacket;
import net.minestom.server.network.packet.server.login.LoginSuccessPacket;
import net.minestom.server.network.packet.server.play.StartConfigurationPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.StringUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.validate.Check;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectionManager {
    private static final Component TIMEOUT_TEXT = Component.text((String)"Timeout", (TextColor)NamedTextColor.RED);
    private CachedPacket defaultTags;
    private final Map<PlayerConnection, Player> connectionPlayerMap = new ConcurrentHashMap<PlayerConnection, Player>();
    private final MessagePassingQueue<Player> waitingPlayers = new MpscUnboundedArrayQueue(64);
    private final Set<Player> configurationPlayers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> playPlayers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> keepAlivePlayers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> unmodifiableConfigurationPlayers = Collections.unmodifiableSet(this.configurationPlayers);
    private final Set<Player> unmodifiablePlayPlayers = Collections.unmodifiableSet(this.playPlayers);
    private final CachedPacket resetChatPacket = new CachedPacket(new ResetChatPacket());
    private volatile UuidProvider uuidProvider = (playerConnection, username) -> UUID.randomUUID();
    private volatile PlayerProvider playerProvider = Player::new;

    private CachedPacket getDefaultTags() {
        CachedPacket defaultTags = this.defaultTags;
        if (defaultTags == null) {
            TagsPacket packet = MinecraftServer.getTagManager().packet();
            this.defaultTags = defaultTags = new CachedPacket(packet);
        }
        return defaultTags;
    }

    public int getOnlinePlayerCount() {
        return this.playPlayers.size();
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getOnlinePlayers() {
        return this.unmodifiablePlayPlayers;
    }

    @NotNull
    public @NotNull Collection<@NotNull Player> getConfigPlayers() {
        return this.unmodifiableConfigurationPlayers;
    }

    public Player getPlayer(@NotNull PlayerConnection connection) {
        return this.connectionPlayerMap.get(connection);
    }

    @Nullable
    public Player getOnlinePlayerByUsername(@NotNull String username) {
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getUsername().equalsIgnoreCase(username)) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public Player getOnlinePlayerByUuid(@NotNull UUID uuid) {
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getUuid().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    @Nullable
    public Player findOnlinePlayer(@NotNull String username) {
        Player exact = this.getOnlinePlayerByUsername(username);
        if (exact != null) {
            return exact;
        }
        String username1 = username.toLowerCase(Locale.ROOT);
        Function<Player, Double> distanceFunction = player -> {
            String username2 = player.getUsername().toLowerCase(Locale.ROOT);
            return StringUtils.jaroWinklerScore(username1, username2);
        };
        return this.getOnlinePlayers().stream().min(Comparator.comparingDouble(distanceFunction::apply)).filter(player -> (Double)distanceFunction.apply((Player)player) > 0.0).orElse(null);
    }

    public void setUuidProvider(@Nullable UuidProvider uuidProvider) {
        this.uuidProvider = uuidProvider != null ? uuidProvider : (playerConnection, username) -> UUID.randomUUID();
    }

    @NotNull
    public UUID getPlayerConnectionUuid(@NotNull PlayerConnection playerConnection, @NotNull String username) {
        return this.uuidProvider.provide(playerConnection, username);
    }

    public void setPlayerProvider(@Nullable PlayerProvider playerProvider) {
        this.playerProvider = playerProvider != null ? playerProvider : Player::new;
    }

    @ApiStatus.Internal
    @NotNull
    public Player createPlayer(@NotNull PlayerConnection connection, @NotNull UUID uuid, @NotNull String username) {
        Player player = this.playerProvider.createPlayer(uuid, username, connection);
        this.connectionPlayerMap.put(connection, player);
        CompletableFuture<Void> future = this.transitionLoginToConfig(player);
        if (ServerFlag.INSIDE_TEST) {
            future.join();
        }
        return player;
    }

    @ApiStatus.Internal
    @NotNull
    public CompletableFuture<Void> transitionLoginToConfig(@NotNull Player player) {
        return AsyncUtils.runAsync(() -> {
            PlayerConnection playerConnection = player.getPlayerConnection();
            if (playerConnection instanceof PlayerSocketConnection) {
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)playerConnection;
                int threshold = MinecraftServer.getCompressionThreshold();
                if (threshold > 0) {
                    socketConnection.startCompression();
                }
            }
            LoginPluginMessageProcessor pluginMessageProcessor = playerConnection.loginPluginMessageProcessor();
            AsyncPlayerPreLoginEvent asyncPlayerPreLoginEvent = new AsyncPlayerPreLoginEvent(player, pluginMessageProcessor);
            EventDispatcher.call(asyncPlayerPreLoginEvent);
            if (!player.isOnline()) {
                return;
            }
            String eventUsername = asyncPlayerPreLoginEvent.getUsername();
            UUID eventUuid = asyncPlayerPreLoginEvent.getPlayerUuid();
            if (!player.getUsername().equals(eventUsername)) {
                player.setUsernameField(eventUsername);
            }
            try {
                pluginMessageProcessor.awaitReplies(ServerFlag.LOGIN_PLUGIN_MESSAGE_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                player.kick(LoginListener.INVALID_PROXY_RESPONSE);
                throw new RuntimeException("Error getting replies for login plugin messages", t);
            }
            LoginSuccessPacket loginSuccessPacket = new LoginSuccessPacket(player.getUuid(), player.getUsername(), 0, true);
            playerConnection.sendPacket(loginSuccessPacket);
        });
    }

    @ApiStatus.Internal
    public void transitionPlayToConfig(@NotNull Player player) {
        player.sendPacket(new StartConfigurationPacket());
        this.configurationPlayers.add(player);
    }

    @ApiStatus.Internal
    public CompletableFuture<Void> doConfiguration(@NotNull Player player, boolean isFirstConfig) {
        if (isFirstConfig) {
            this.configurationPlayers.add(player);
            this.keepAlivePlayers.add(player);
        }
        PlayerConnection connection = player.getPlayerConnection();
        connection.setConnectionState(ConnectionState.CONFIGURATION);
        player.sendPacket(PluginMessagePacket.brandPacket(MinecraftServer.getBrandName()));
        CompletableFuture<List<SelectKnownPacksPacket.Entry>> knownPacksFuture = connection.requestKnownPacks(List.of(SelectKnownPacksPacket.MINECRAFT_CORE));
        return AsyncUtils.runAsync(() -> {
            CompletableFuture<Void> packFuture;
            AsyncPlayerConfigurationEvent event = new AsyncPlayerConfigurationEvent(player, isFirstConfig);
            EventDispatcher.call(event);
            if (!player.isOnline()) {
                return;
            }
            player.sendPacket(new UpdateEnabledFeaturesPacket(event.getFeatureFlags().stream().map(StaticProtocolObject::name).toList()));
            Instance spawningInstance = event.getSpawningInstance();
            Check.notNull(spawningInstance, "You need to specify a spawning instance in the AsyncPlayerConfigurationEvent");
            if (event.willClearChat()) {
                player.sendPacket(this.resetChatPacket);
            }
            if (event.willSendRegistryData()) {
                List knownPacks;
                try {
                    knownPacks = (List)knownPacksFuture.get(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException("Client failed to respond to known packs request", e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Error receiving known packs", e);
                }
                boolean excludeVanilla = knownPacks.contains(SelectKnownPacksPacket.MINECRAFT_CORE);
                ServerProcess serverProcess = MinecraftServer.process();
                player.sendPacket(serverProcess.chatType().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.dimensionType().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.biome().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.damageType().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.trimMaterial().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.trimPattern().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.bannerPattern().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.wolfVariant().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.enchantment().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.paintingVariant().registryDataPacket(excludeVanilla));
                player.sendPacket(serverProcess.jukeboxSong().registryDataPacket(excludeVanilla));
                player.sendPacket(this.getDefaultTags());
            }
            if ((packFuture = player.getResourcePackFuture()) != null) {
                packFuture.join();
            }
            this.keepAlivePlayers.remove(player);
            player.setPendingOptions(spawningInstance, event.isHardcore());
            player.sendPacket(new FinishConfigurationPacket());
        });
    }

    @ApiStatus.Internal
    public void transitionConfigToPlay(@NotNull Player player) {
        this.waitingPlayers.relaxedOffer((Object)player);
    }

    @ApiStatus.Internal
    public synchronized void removePlayer(@NotNull PlayerConnection connection) {
        Player player = this.connectionPlayerMap.remove(connection);
        if (player == null) {
            return;
        }
        this.configurationPlayers.remove(player);
        this.playPlayers.remove(player);
        this.keepAlivePlayers.remove(player);
    }

    public synchronized void shutdown() {
        this.configurationPlayers.clear();
        this.playPlayers.clear();
        this.keepAlivePlayers.clear();
        this.connectionPlayerMap.clear();
    }

    public void tick(long tickStart) {
        this.updateWaitingPlayers();
        this.handleKeepAlive(this.keepAlivePlayers, tickStart);
        this.configurationPlayers.forEach(Player::interpretPacketQueue);
    }

    @ApiStatus.Internal
    public void updateWaitingPlayers() {
        this.waitingPlayers.drain(player -> {
            if (!player.isOnline()) {
                return;
            }
            player.getPlayerConnection().setConnectionState(ConnectionState.PLAY);
            this.playPlayers.add((Player)player);
            this.keepAlivePlayers.add((Player)player);
            player.refreshAnswerKeepAlive(true);
            CompletableFuture<Void> spawnFuture = player.UNSAFE_init();
            if (ServerFlag.INSIDE_TEST) {
                spawnFuture.join();
            }
        });
    }

    private void handleKeepAlive(@NotNull Collection<Player> playerGroup, long tickStart) {
        KeepAlivePacket keepAlivePacket = new KeepAlivePacket(tickStart);
        for (Player player : playerGroup) {
            long lastKeepAlive = tickStart - player.getLastKeepAlive();
            if (lastKeepAlive > ServerFlag.KEEP_ALIVE_DELAY && player.didAnswerKeepAlive()) {
                player.refreshKeepAlive(tickStart);
                player.sendPacket(keepAlivePacket);
                continue;
            }
            if (lastKeepAlive < ServerFlag.KEEP_ALIVE_KICK) continue;
            player.kick(TIMEOUT_TEXT);
        }
    }
}

