/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener.preplay;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.extras.mojangAuth.MojangCrypt;
import net.minestom.server.extras.velocity.VelocityProxy;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.login.ClientEncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.login.ClientLoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginStartPacket;
import net.minestom.server.network.packet.server.login.EncryptionRequestPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.network.plugin.LoginPlugin;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.mojang.MojangUtils;
import org.jetbrains.annotations.NotNull;

public final class LoginListener {
    private static final ConnectionManager CONNECTION_MANAGER = MinecraftServer.getConnectionManager();
    private static final Component ALREADY_CONNECTED = Component.text((String)"You are already on this server", (TextColor)NamedTextColor.RED);
    private static final Component ERROR_DURING_LOGIN = Component.text((String)"Error during login!", (TextColor)NamedTextColor.RED);
    private static final Component ERROR_MALFORMED_USERNAME = Component.text((String)"Error malformed username", (TextColor)NamedTextColor.RED);
    private static final Component ENCRYPTION_FAILED = Component.text((String)"Encryption failed!", (TextColor)NamedTextColor.RED);
    private static final Component ERROR_MOJANG_RESPONSE = Component.text((String)"Failed to contact Mojang's Session Servers (Are they down?)", (TextColor)NamedTextColor.RED);
    public static final Component INVALID_PROXY_RESPONSE = Component.text((String)"Invalid proxy response!", (TextColor)NamedTextColor.RED);

    public static void loginStartListener(@NotNull ClientLoginStartPacket packet, @NotNull PlayerConnection connection) {
        PlayerSocketConnection socketConnection;
        boolean isSocketConnection = connection instanceof PlayerSocketConnection;
        if (isSocketConnection) {
            socketConnection = (PlayerSocketConnection)connection;
            socketConnection.UNSAFE_setLoginUsername(packet.username());
            if (VelocityProxy.isEnabled()) {
                connection.loginPluginMessageProcessor().request("velocity:player_info", new byte[0]).thenAccept(response -> LoginListener.handleVelocityProxyResponse(socketConnection, response));
                return;
            }
        }
        if (MojangAuth.isEnabled() && isSocketConnection) {
            if (CONNECTION_MANAGER.getOnlinePlayerByUsername(packet.username()) != null) {
                connection.kick(ALREADY_CONNECTED);
                return;
            }
            socketConnection = (PlayerSocketConnection)connection;
            byte[] publicKey = MojangAuth.getKeyPair().getPublic().getEncoded();
            byte[] nonce = new byte[4];
            ThreadLocalRandom.current().nextBytes(nonce);
            socketConnection.setNonce(nonce);
            socketConnection.sendPacket(new EncryptionRequestPacket("", publicKey, nonce, true));
        } else {
            boolean bungee = BungeeCordProxy.isEnabled();
            AsyncUtils.runAsync(() -> {
                try {
                    UUID playerUuid = bungee && isSocketConnection ? ((PlayerSocketConnection)connection).gameProfile().uuid() : CONNECTION_MANAGER.getPlayerConnectionUuid(connection, packet.username());
                    CONNECTION_MANAGER.createPlayer(connection, playerUuid, packet.username());
                }
                catch (Exception exception) {
                    connection.kick((Component)Component.text((String)(exception.getClass().getSimpleName() + ": " + exception.getMessage())));
                    MinecraftServer.getExceptionManager().handleException(exception);
                }
            });
        }
    }

    public static void loginEncryptionResponseListener(@NotNull ClientEncryptionResponsePacket packet, @NotNull PlayerConnection connection) {
        if (!(connection instanceof PlayerSocketConnection)) {
            return;
        }
        PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
        AsyncUtils.runAsync(() -> {
            boolean verificationFailed;
            String loginUsername = socketConnection.getLoginUsername();
            if (loginUsername == null || loginUsername.isEmpty()) {
                connection.kick(ERROR_MALFORMED_USERNAME);
                return;
            }
            boolean hasPublicKey = connection.playerPublicKey() != null;
            boolean bl = verificationFailed = hasPublicKey || !Arrays.equals(socketConnection.getNonce(), MojangCrypt.decryptUsingKey(MojangAuth.getKeyPair().getPrivate(), packet.encryptedVerifyToken()));
            if (verificationFailed) {
                MinecraftServer.LOGGER.error("Encryption failed for {}", (Object)loginUsername);
                connection.kick(ENCRYPTION_FAILED);
                return;
            }
            byte[] digestedData = MojangCrypt.digestData("", MojangAuth.getKeyPair().getPublic(), LoginListener.getSecretKey(packet.sharedSecret()));
            if (digestedData == null) {
                MinecraftServer.LOGGER.error("Connection {} failed initializing encryption.", (Object)socketConnection.getRemoteAddress());
                connection.kick(ENCRYPTION_FAILED);
                return;
            }
            String serverId = new BigInteger(digestedData).toString(16);
            try {
                JsonObject gameProfile = MojangUtils.authenticateSession(loginUsername, serverId, socketConnection.getRemoteAddress());
                socketConnection.setEncryptionKey(LoginListener.getSecretKey(packet.sharedSecret()));
                UUID profileUUID = UUID.fromString(gameProfile.get("id").getAsString().replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
                String profileName = gameProfile.get("name").getAsString();
                MinecraftServer.LOGGER.info("UUID of player {} is {}", (Object)profileName, (Object)profileUUID);
                CONNECTION_MANAGER.createPlayer(connection, profileUUID, profileName);
                ArrayList<GameProfile.Property> propertyList = new ArrayList<GameProfile.Property>();
                for (JsonElement element : gameProfile.get("properties").getAsJsonArray()) {
                    JsonObject object = element.getAsJsonObject();
                    propertyList.add(new GameProfile.Property(object.get("name").getAsString(), object.get("value").getAsString(), object.get("signature").getAsString()));
                }
                socketConnection.UNSAFE_setProfile(new GameProfile(profileUUID, profileName, propertyList));
            }
            catch (IOException e) {
                socketConnection.kick(ERROR_MOJANG_RESPONSE);
                MinecraftServer.getExceptionManager().handleException(e);
            }
            catch (Exception e) {
                socketConnection.kick(ERROR_DURING_LOGIN);
                MinecraftServer.getExceptionManager().handleException(e);
            }
        });
    }

    private static SecretKey getSecretKey(byte[] sharedSecret) {
        return MojangCrypt.decryptByteToSecretKey(MojangAuth.getKeyPair().getPrivate(), sharedSecret);
    }

    private static void handleVelocityProxyResponse(PlayerSocketConnection socketConnection, LoginPlugin.Response response) {
        NetworkBuffer buffer;
        byte[] data = response.payload();
        InetSocketAddress socketAddress = null;
        GameProfile gameProfile = null;
        boolean success = false;
        if (data != null && data.length > 0 && (success = VelocityProxy.checkIntegrity(buffer = NetworkBuffer.wrap(data, 0, data.length)))) {
            InetAddress address;
            try {
                address = InetAddress.getByName(buffer.read(NetworkBuffer.STRING));
            }
            catch (UnknownHostException e) {
                socketConnection.kick(INVALID_PROXY_RESPONSE);
                MinecraftServer.getExceptionManager().handleException(e);
                return;
            }
            int port = ((InetSocketAddress)socketConnection.getRemoteAddress()).getPort();
            socketAddress = new InetSocketAddress(address, port);
            gameProfile = GameProfile.SERIALIZER.read(buffer);
        }
        if (success) {
            socketConnection.setRemoteAddress(socketAddress);
            socketConnection.UNSAFE_setProfile(gameProfile);
            CONNECTION_MANAGER.createPlayer(socketConnection, gameProfile.uuid(), gameProfile.name());
        } else {
            socketConnection.kick(INVALID_PROXY_RESPONSE);
        }
    }

    public static void loginPluginResponseListener(@NotNull ClientLoginPluginResponsePacket packet, @NotNull PlayerConnection connection) {
        try {
            LoginPluginMessageProcessor messageProcessor = connection.loginPluginMessageProcessor();
            messageProcessor.handleResponse(packet.messageId(), packet.data());
        }
        catch (Throwable t) {
            connection.kick(ERROR_DURING_LOGIN);
            MinecraftServer.LOGGER.error("Error handling Login Plugin Response", t);
            MinecraftServer.getExceptionManager().handleException(t);
        }
    }

    public static void loginAckListener(@NotNull ClientLoginAcknowledgedPacket ignored, @NotNull PlayerConnection connection) {
        Player player = Objects.requireNonNull(connection.getPlayer());
        CONNECTION_MANAGER.doConfiguration(player, true);
    }
}

