/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener.manager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minestom.server.MinecraftServer;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.player.PlayerPacketEvent;
import net.minestom.server.listener.AbilitiesListener;
import net.minestom.server.listener.AdvancementTabListener;
import net.minestom.server.listener.AnimationListener;
import net.minestom.server.listener.AnvilListener;
import net.minestom.server.listener.BlockPlacementListener;
import net.minestom.server.listener.BookListener;
import net.minestom.server.listener.ChatMessageListener;
import net.minestom.server.listener.ChunkBatchListener;
import net.minestom.server.listener.CreativeInventoryActionListener;
import net.minestom.server.listener.EntityActionListener;
import net.minestom.server.listener.PlayConfigListener;
import net.minestom.server.listener.PlayPingListener;
import net.minestom.server.listener.PlayStatusListener;
import net.minestom.server.listener.PlayerDiggingListener;
import net.minestom.server.listener.PlayerHeldListener;
import net.minestom.server.listener.PlayerPositionListener;
import net.minestom.server.listener.PlayerVehicleListener;
import net.minestom.server.listener.RecipeListener;
import net.minestom.server.listener.SpectateListener;
import net.minestom.server.listener.TabCompleteListener;
import net.minestom.server.listener.UseEntityListener;
import net.minestom.server.listener.UseItemListener;
import net.minestom.server.listener.WindowListener;
import net.minestom.server.listener.common.CookieListener;
import net.minestom.server.listener.common.KeepAliveListener;
import net.minestom.server.listener.common.PluginMessageListener;
import net.minestom.server.listener.common.ResourcePackListener;
import net.minestom.server.listener.common.SettingsListener;
import net.minestom.server.listener.manager.PacketPlayListenerConsumer;
import net.minestom.server.listener.manager.PacketPrePlayListenerConsumer;
import net.minestom.server.listener.preplay.ConfigListener;
import net.minestom.server.listener.preplay.HandshakeListener;
import net.minestom.server.listener.preplay.LoginListener;
import net.minestom.server.listener.preplay.StatusListener;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.common.ClientCookieResponsePacket;
import net.minestom.server.network.packet.client.common.ClientKeepAlivePacket;
import net.minestom.server.network.packet.client.common.ClientPingRequestPacket;
import net.minestom.server.network.packet.client.common.ClientPluginMessagePacket;
import net.minestom.server.network.packet.client.common.ClientPongPacket;
import net.minestom.server.network.packet.client.common.ClientResourcePackStatusPacket;
import net.minestom.server.network.packet.client.common.ClientSettingsPacket;
import net.minestom.server.network.packet.client.configuration.ClientFinishConfigurationPacket;
import net.minestom.server.network.packet.client.configuration.ClientSelectKnownPacksPacket;
import net.minestom.server.network.packet.client.handshake.ClientHandshakePacket;
import net.minestom.server.network.packet.client.login.ClientEncryptionResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginAcknowledgedPacket;
import net.minestom.server.network.packet.client.login.ClientLoginPluginResponsePacket;
import net.minestom.server.network.packet.client.login.ClientLoginStartPacket;
import net.minestom.server.network.packet.client.play.ClientAdvancementTabPacket;
import net.minestom.server.network.packet.client.play.ClientAnimationPacket;
import net.minestom.server.network.packet.client.play.ClientChatMessagePacket;
import net.minestom.server.network.packet.client.play.ClientChatSessionUpdatePacket;
import net.minestom.server.network.packet.client.play.ClientChunkBatchReceivedPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCommandChatPacket;
import net.minestom.server.network.packet.client.play.ClientConfigurationAckPacket;
import net.minestom.server.network.packet.client.play.ClientCraftRecipeRequest;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.network.packet.client.play.ClientEditBookPacket;
import net.minestom.server.network.packet.client.play.ClientEntityActionPacket;
import net.minestom.server.network.packet.client.play.ClientHeldItemChangePacket;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;
import net.minestom.server.network.packet.client.play.ClientNameItemPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerAbilitiesPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerBlockPlacementPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerDiggingPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionAndRotationPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerPositionPacket;
import net.minestom.server.network.packet.client.play.ClientPlayerRotationPacket;
import net.minestom.server.network.packet.client.play.ClientSpectatePacket;
import net.minestom.server.network.packet.client.play.ClientStatusPacket;
import net.minestom.server.network.packet.client.play.ClientSteerBoatPacket;
import net.minestom.server.network.packet.client.play.ClientSteerVehiclePacket;
import net.minestom.server.network.packet.client.play.ClientTabCompletePacket;
import net.minestom.server.network.packet.client.play.ClientTeleportConfirmPacket;
import net.minestom.server.network.packet.client.play.ClientUseItemPacket;
import net.minestom.server.network.packet.client.play.ClientVehicleMovePacket;
import net.minestom.server.network.packet.client.status.StatusRequestPacket;
import net.minestom.server.network.player.PlayerConnection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PacketListenerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketListenerManager.class);
    private final Map<Class<? extends ClientPacket>, PacketPrePlayListenerConsumer>[] listeners = new Map[ConnectionState.values().length];

    public PacketListenerManager() {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i] = new ConcurrentHashMap<Class<? extends ClientPacket>, PacketPrePlayListenerConsumer>();
        }
        this.setListener(ConnectionState.HANDSHAKE, ClientHandshakePacket.class, HandshakeListener::listener);
        this.setListener(ConnectionState.STATUS, StatusRequestPacket.class, StatusListener::requestListener);
        this.setListener(ConnectionState.STATUS, ClientPingRequestPacket.class, StatusListener::pingRequestListener);
        this.setListener(ConnectionState.LOGIN, ClientLoginStartPacket.class, LoginListener::loginStartListener);
        this.setListener(ConnectionState.LOGIN, ClientEncryptionResponsePacket.class, LoginListener::loginEncryptionResponseListener);
        this.setListener(ConnectionState.LOGIN, ClientLoginPluginResponsePacket.class, LoginListener::loginPluginResponseListener);
        this.setListener(ConnectionState.LOGIN, ClientLoginAcknowledgedPacket.class, LoginListener::loginAckListener);
        this.setListener(ConnectionState.LOGIN, ClientCookieResponsePacket.class, CookieListener::handleCookieResponse);
        this.setConfigurationListener(ClientSettingsPacket.class, SettingsListener::listener);
        this.setConfigurationListener(ClientPluginMessagePacket.class, PluginMessageListener::listener);
        this.setConfigurationListener(ClientKeepAlivePacket.class, KeepAliveListener::listener);
        this.setConfigurationListener(ClientPongPacket.class, (packet, player) -> {});
        this.setConfigurationListener(ClientResourcePackStatusPacket.class, ResourcePackListener::listener);
        this.setConfigurationListener(ClientSelectKnownPacksPacket.class, ConfigListener::selectKnownPacks);
        this.setConfigurationListener(ClientFinishConfigurationPacket.class, ConfigListener::finishConfigListener);
        this.setListener(ConnectionState.CONFIGURATION, ClientCookieResponsePacket.class, CookieListener::handleCookieResponse);
        this.setPlayListener(ClientKeepAlivePacket.class, KeepAliveListener::listener);
        this.setPlayListener(ClientCommandChatPacket.class, ChatMessageListener::commandChatListener);
        this.setPlayListener(ClientChatMessagePacket.class, ChatMessageListener::chatMessageListener);
        this.setPlayListener(ClientClickWindowPacket.class, WindowListener::clickWindowListener);
        this.setPlayListener(ClientCloseWindowPacket.class, WindowListener::closeWindowListener);
        this.setPlayListener(ClientConfigurationAckPacket.class, PlayConfigListener::configAckListener);
        this.setPlayListener(ClientPongPacket.class, WindowListener::pong);
        this.setPlayListener(ClientEntityActionPacket.class, EntityActionListener::listener);
        this.setPlayListener(ClientHeldItemChangePacket.class, PlayerHeldListener::heldListener);
        this.setPlayListener(ClientPlayerBlockPlacementPacket.class, BlockPlacementListener::listener);
        this.setPlayListener(ClientSteerVehiclePacket.class, PlayerVehicleListener::steerVehicleListener);
        this.setPlayListener(ClientVehicleMovePacket.class, PlayerVehicleListener::vehicleMoveListener);
        this.setPlayListener(ClientSteerBoatPacket.class, PlayerVehicleListener::boatSteerListener);
        this.setPlayListener(ClientPlayerPacket.class, PlayerPositionListener::playerPacketListener);
        this.setPlayListener(ClientPlayerRotationPacket.class, PlayerPositionListener::playerLookListener);
        this.setPlayListener(ClientPlayerPositionPacket.class, PlayerPositionListener::playerPositionListener);
        this.setPlayListener(ClientPlayerPositionAndRotationPacket.class, PlayerPositionListener::playerPositionAndLookListener);
        this.setPlayListener(ClientTeleportConfirmPacket.class, PlayerPositionListener::teleportConfirmListener);
        this.setPlayListener(ClientPlayerDiggingPacket.class, PlayerDiggingListener::playerDiggingListener);
        this.setPlayListener(ClientAnimationPacket.class, AnimationListener::animationListener);
        this.setPlayListener(ClientInteractEntityPacket.class, UseEntityListener::useEntityListener);
        this.setPlayListener(ClientUseItemPacket.class, UseItemListener::useItemListener);
        this.setPlayListener(ClientStatusPacket.class, PlayStatusListener::listener);
        this.setPlayListener(ClientSettingsPacket.class, SettingsListener::listener);
        this.setPlayListener(ClientCreativeInventoryActionPacket.class, CreativeInventoryActionListener::listener);
        this.setPlayListener(ClientCraftRecipeRequest.class, RecipeListener::listener);
        this.setPlayListener(ClientTabCompletePacket.class, TabCompleteListener::listener);
        this.setPlayListener(ClientPluginMessagePacket.class, PluginMessageListener::listener);
        this.setPlayListener(ClientPlayerAbilitiesPacket.class, AbilitiesListener::listener);
        this.setPlayListener(ClientResourcePackStatusPacket.class, ResourcePackListener::listener);
        this.setPlayListener(ClientAdvancementTabPacket.class, AdvancementTabListener::listener);
        this.setPlayListener(ClientSpectatePacket.class, SpectateListener::listener);
        this.setPlayListener(ClientEditBookPacket.class, BookListener::listener);
        this.setPlayListener(ClientChatSessionUpdatePacket.class, (packet, player) -> {});
        this.setPlayListener(ClientChunkBatchReceivedPacket.class, ChunkBatchListener::batchReceivedListener);
        this.setPlayListener(ClientPingRequestPacket.class, PlayPingListener::requestListener);
        this.setListener(ConnectionState.PLAY, ClientCookieResponsePacket.class, CookieListener::handleCookieResponse);
        this.setPlayListener(ClientNameItemPacket.class, AnvilListener::nameItemListener);
    }

    public <T extends ClientPacket> void processClientPacket(@NotNull T packet, @NotNull PlayerConnection connection) {
        ConnectionState state = connection.getConnectionState();
        Class<?> clazz = packet.getClass();
        PacketPrePlayListenerConsumer packetListenerConsumer = this.listeners[state.ordinal()].get(clazz);
        if (packetListenerConsumer == null) {
            LOGGER.warn("Packet {}:{} does not have any default listener! (The issue likely comes from Minestom)", clazz, (Object)state);
            return;
        }
        if (state == ConnectionState.PLAY) {
            PlayerPacketEvent playerPacketEvent = new PlayerPacketEvent(connection.getPlayer(), packet);
            EventDispatcher.call(playerPacketEvent);
            if (playerPacketEvent.isCancelled()) {
                return;
            }
        }
        try {
            packetListenerConsumer.accept(packet, connection);
        }
        catch (Exception e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    public <T extends ClientPacket> void setListener(@NotNull ConnectionState state, @NotNull Class<T> packetClass, @NotNull PacketPrePlayListenerConsumer<T> consumer) {
        this.listeners[state.ordinal()].put(packetClass, consumer);
    }

    public <T extends ClientPacket> void setPlayListener(@NotNull Class<T> packetClass, @NotNull PacketPlayListenerConsumer<T> consumer) {
        this.setListener(ConnectionState.PLAY, packetClass, (packet, playerConnection) -> consumer.accept(packet, playerConnection.getPlayer()));
    }

    public <T extends ClientPacket> void setConfigurationListener(@NotNull Class<T> packetClass, @NotNull PacketPlayListenerConsumer<T> consumer) {
        this.setListener(ConnectionState.CONFIGURATION, packetClass, (packet, playerConnection) -> consumer.accept(packet, playerConnection.getPlayer()));
    }

    @Deprecated
    public <T extends ClientPacket> void setListener(@NotNull Class<T> packetClass, @NotNull PacketPlayListenerConsumer<T> consumer) {
        this.setPlayListener(packetClass, consumer);
    }
}

