/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record EnchantmentList(@NotNull Map<DynamicRegistry.Key<Enchantment>, Integer> enchantments, boolean showInTooltip) {
    public static final EnchantmentList EMPTY = new EnchantmentList(Map.of(), true);
    public static final NetworkBuffer.Type<EnchantmentList> NETWORK_TYPE = NetworkBufferTemplate.template(Enchantment.NETWORK_TYPE.mapValue(NetworkBuffer.VAR_INT, Short.MAX_VALUE), EnchantmentList::enchantments, NetworkBuffer.BOOLEAN, EnchantmentList::showInTooltip, EnchantmentList::new);
    public static BinaryTagSerializer<EnchantmentList> NBT_TYPE = new BinaryTagSerializer<EnchantmentList>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull EnchantmentList value) {
            CompoundBinaryTag.Builder levels = CompoundBinaryTag.builder();
            for (Map.Entry<DynamicRegistry.Key<Enchantment>, Integer> entry : value.enchantments.entrySet()) {
                levels.put(entry.getKey().name(), BinaryTagSerializer.INT.write(context, entry.getValue()));
            }
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("levels", (BinaryTag)levels.build())).putBoolean("show_in_tooltip", value.showInTooltip)).build();
        }

        @Override
        @NotNull
        public EnchantmentList read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag raw) {
            if (!(raw instanceof CompoundBinaryTag)) {
                throw new IllegalArgumentException("Enchantment list must be a compound tag");
            }
            CompoundBinaryTag tag = (CompoundBinaryTag)raw;
            CompoundBinaryTag levels = tag.keySet().contains("levels") ? tag.getCompound("levels") : tag;
            HashMap<DynamicRegistry.Key<Enchantment>, Integer> enchantments = new HashMap<DynamicRegistry.Key<Enchantment>, Integer>(levels.size());
            for (Map.Entry entry : levels) {
                DynamicRegistry.Key<Enchantment> enchantment = Enchantment.NBT_TYPE.read(context, (BinaryTag)StringBinaryTag.stringBinaryTag((String)((String)entry.getKey())));
                int level = BinaryTagSerializer.INT.read((BinaryTag)entry.getValue());
                if (level <= 0) continue;
                enchantments.put(enchantment, level);
            }
            boolean showInTooltip = tag.getBoolean("show_in_tooltip", true);
            return new EnchantmentList(enchantments, showInTooltip);
        }
    };

    public EnchantmentList(@NotNull Map<DynamicRegistry.Key<Enchantment>, Integer> enchantments, boolean showInTooltip) {
        enchantments = Map.copyOf(enchantments);
    }

    public EnchantmentList(@NotNull Map<DynamicRegistry.Key<Enchantment>, Integer> enchantments) {
        this(enchantments, true);
    }

    public EnchantmentList(@NotNull DynamicRegistry.Key<Enchantment> enchantment, int level) {
        this(Map.of(enchantment, level), true);
    }

    public boolean has(@NotNull DynamicRegistry.Key<Enchantment> enchantment) {
        return this.enchantments.containsKey(enchantment);
    }

    public int level(@NotNull DynamicRegistry.Key<Enchantment> enchantment) {
        return this.enchantments.getOrDefault(enchantment, 0);
    }

    @NotNull
    public EnchantmentList with(@NotNull DynamicRegistry.Key<Enchantment> enchantment, int level) {
        HashMap<DynamicRegistry.Key<Enchantment>, Integer> newEnchantments = new HashMap<DynamicRegistry.Key<Enchantment>, Integer>(this.enchantments);
        newEnchantments.put(enchantment, level);
        return new EnchantmentList(newEnchantments, this.showInTooltip);
    }

    @NotNull
    public EnchantmentList remove(@NotNull DynamicRegistry.Key<Enchantment> enchantment) {
        HashMap<DynamicRegistry.Key<Enchantment>, Integer> newEnchantments = new HashMap<DynamicRegistry.Key<Enchantment>, Integer>(this.enchantments);
        newEnchantments.remove(enchantment);
        return new EnchantmentList(newEnchantments, this.showInTooltip);
    }

    @NotNull
    public EnchantmentList withTooltip(boolean showInTooltip) {
        return new EnchantmentList(this.enchantments, showInTooltip);
    }
}

