/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event.player;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minestom.server.entity.Player;
import net.minestom.server.event.trait.PlayerEvent;
import net.minestom.server.network.plugin.LoginPlugin;
import net.minestom.server.network.plugin.LoginPluginMessageProcessor;
import org.jetbrains.annotations.NotNull;

public class AsyncPlayerPreLoginEvent
implements PlayerEvent {
    private final Player player;
    private final LoginPluginMessageProcessor pluginMessageProcessor;
    private String username;

    public AsyncPlayerPreLoginEvent(@NotNull Player player, @NotNull LoginPluginMessageProcessor pluginMessageProcessor) {
        this.player = player;
        this.pluginMessageProcessor = pluginMessageProcessor;
        this.username = player.getUsername();
    }

    @NotNull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@NotNull String username) {
        this.username = username;
    }

    @NotNull
    public UUID getPlayerUuid() {
        return this.player.getUuid();
    }

    @NotNull
    public CompletableFuture<LoginPlugin.Response> sendPluginRequest(String channel, byte[] requestPayload) {
        return this.pluginMessageProcessor.request(channel, requestPayload);
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }
}

