/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentResource
extends Argument<String> {
    public static final int SPACE_ERROR = 1;
    private final String identifier;

    public ArgumentResource(@NotNull String id, @NotNull String identifier) {
        super(id);
        this.identifier = identifier;
    }

    @Override
    @NotNull
    public String parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        if (input.contains(" ")) {
            throw new ArgumentSyntaxException("Resource location cannot contain space character", input, 1);
        }
        return input;
    }

    @Override
    public String parser() {
        return "minecraft:resource";
    }

    public String toString() {
        return String.format("Resource<%s>", this.getId());
    }

    @Override
    public byte @Nullable [] nodeProperties() {
        return NetworkBuffer.makeArray(NetworkBuffer.STRING, this.identifier);
    }
}

