/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Iterator;
import net.minestom.server.collision.RayUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.EntityPose;
import net.minestom.server.instance.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BoundingBox
extends Record
implements Shape {
    private final Vec relativeStart;
    private final Vec relativeEnd;
    private static final BoundingBox SLEEPING = new BoundingBox(0.2, 0.2, 0.2);
    private static final BoundingBox SNEAKING = new BoundingBox(0.6, 1.5, 0.6);
    private static final BoundingBox SMALL = new BoundingBox(0.6, 0.6, 0.6);
    static final BoundingBox ZERO = new BoundingBox(Vec.ZERO, Vec.ZERO);

    public BoundingBox(double width, double height, double depth, Point offset) {
        this(Vec.fromPoint(offset), new Vec(width, height, depth).add(offset));
    }

    public BoundingBox(double width, double height, double depth) {
        this(width, height, depth, new Vec(-width / 2.0, 0.0, -depth / 2.0));
    }

    public BoundingBox(Vec relativeStart, Vec relativeEnd) {
        this.relativeStart = relativeStart;
        this.relativeEnd = relativeEnd;
    }

    @Override
    public boolean isOccluded(@NotNull Shape shape, @NotNull BlockFace face) {
        return false;
    }

    @Override
    public boolean intersectBox(@NotNull Point positionRelative, @NotNull BoundingBox boundingBox) {
        return this.minX() + positionRelative.x() <= boundingBox.maxX() - 5.0E-7 && this.maxX() + positionRelative.x() >= boundingBox.minX() + 5.0E-7 && this.minY() + positionRelative.y() <= boundingBox.maxY() - 5.0E-7 && this.maxY() + positionRelative.y() >= boundingBox.minY() + 5.0E-7 && this.minZ() + positionRelative.z() <= boundingBox.maxZ() - 5.0E-7 && this.maxZ() + positionRelative.z() >= boundingBox.minZ() + 5.0E-7;
    }

    @Override
    public boolean intersectBoxSwept(@NotNull Point rayStart, @NotNull Point rayDirection, @NotNull Point shapePos, @NotNull BoundingBox moving, @NotNull SweepResult finalResult) {
        if (RayUtils.BoundingBoxIntersectionCheck(moving, rayStart, rayDirection, this, shapePos, finalResult)) {
            finalResult.collidedPositionX = rayStart.x() + rayDirection.x() * finalResult.res;
            finalResult.collidedPositionY = rayStart.y() + rayDirection.y() * finalResult.res;
            finalResult.collidedPositionZ = rayStart.z() + rayDirection.z() * finalResult.res;
            finalResult.collidedShapeX = shapePos.x();
            finalResult.collidedShapeY = shapePos.y();
            finalResult.collidedShapeZ = shapePos.z();
            finalResult.collidedShape = this;
            return true;
        }
        return false;
    }

    public boolean boundingBoxRayIntersectionCheck(Vec start, Vec direction, Pos position) {
        return RayUtils.BoundingBoxRayIntersectionCheck(start, direction, this, position);
    }

    @NotNull
    public BoundingBox expand(double x, double y, double z) {
        return new BoundingBox(this.width() + x, this.height() + y, this.depth() + z);
    }

    @NotNull
    public BoundingBox contract(double x, double y, double z) {
        return new BoundingBox(this.width() - x, this.height() - y, this.depth() - z);
    }

    @NotNull
    public BoundingBox withOffset(Point offset) {
        return new BoundingBox(this.width(), this.height(), this.depth(), offset);
    }

    public double width() {
        return this.relativeEnd.x() - this.relativeStart.x();
    }

    public double height() {
        return this.relativeEnd.y() - this.relativeStart.y();
    }

    public double depth() {
        return this.relativeEnd.z() - this.relativeStart.z();
    }

    public double minX() {
        return this.relativeStart.x();
    }

    public double maxX() {
        return this.relativeEnd.x();
    }

    public double minY() {
        return this.relativeStart.y();
    }

    public double maxY() {
        return this.relativeEnd.y();
    }

    public double minZ() {
        return this.relativeStart.z();
    }

    public double maxZ() {
        return this.relativeEnd.z();
    }

    public PointIterator getBlocks(Point point) {
        return new PointIterator(this, point, AxisMask.NONE, 0.0);
    }

    public PointIterator getBlocks(Point point, AxisMask axisMask, double axis) {
        return new PointIterator(this, point, axisMask, axis);
    }

    @Nullable
    public static BoundingBox fromPose(@NotNull EntityPose pose) {
        return switch (pose) {
            case EntityPose.FALL_FLYING, EntityPose.SWIMMING, EntityPose.SPIN_ATTACK -> SMALL;
            case EntityPose.SLEEPING, EntityPose.DYING -> SLEEPING;
            case EntityPose.SNEAKING -> SNEAKING;
            default -> null;
        };
    }

    @NotNull
    public static BoundingBox fromPoints(@NotNull Point a, @NotNull Point b) {
        Vec aVec = Vec.fromPoint(a);
        Vec min = aVec.min(b);
        Vec max = aVec.max(b);
        Vec dimensions = max.sub(min);
        return new BoundingBox(dimensions.x(), dimensions.y(), dimensions.z(), min);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BoundingBox.class, "relativeStart;relativeEnd", "relativeStart", "relativeEnd"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BoundingBox.class, "relativeStart;relativeEnd", "relativeStart", "relativeEnd"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BoundingBox.class, "relativeStart;relativeEnd", "relativeStart", "relativeEnd"}, this, o);
    }

    @Override
    public Vec relativeStart() {
        return this.relativeStart;
    }

    @Override
    public Vec relativeEnd() {
        return this.relativeEnd;
    }

    public static class PointIterator
    implements Iterator<MutablePoint> {
        private double sx;
        private double sy;
        private double sz;
        double x;
        double y;
        double z;
        private double minX;
        private double minY;
        private double minZ;
        private double maxX;
        private double maxY;
        private double maxZ;
        private final MutablePoint point = new MutablePoint();

        public PointIterator() {
        }

        public PointIterator(BoundingBox boundingBox, Point p, AxisMask axisMask, double axis) {
            this.reset(boundingBox, p, axisMask, axis);
        }

        public void reset(BoundingBox boundingBox, double pointX, double pointY, double pointZ, AxisMask axisMask, int axis) {
            this.minX = (int)Math.floor(boundingBox.minX() + pointX);
            this.minY = (int)Math.floor(boundingBox.minY() + pointY);
            this.minZ = (int)Math.floor(boundingBox.minZ() + pointZ);
            this.maxX = (int)Math.floor(boundingBox.maxX() + pointX);
            this.maxY = (int)Math.floor(boundingBox.maxY() + pointY);
            this.maxZ = (int)Math.floor(boundingBox.maxZ() + pointZ);
            this.x = this.minX;
            this.y = this.minY;
            this.z = this.minZ;
            this.sx = boundingBox.minX() + pointX - this.minX;
            this.sy = boundingBox.minY() + pointY - this.minY;
            this.sz = boundingBox.minZ() + pointZ - this.minZ;
            if (axisMask == AxisMask.X) {
                this.minX = this.x = (double)axis + pointX;
                this.maxX = this.x;
            } else if (axisMask == AxisMask.Y) {
                this.minY = this.y = (double)axis + pointY;
                this.maxY = this.y;
            } else if (axisMask == AxisMask.Z) {
                this.minZ = this.z = (double)axis + pointZ;
                this.maxZ = this.z;
            }
        }

        public void reset(BoundingBox boundingBox, Point p, AxisMask axisMask, double axis) {
            this.reset(boundingBox, p.x(), p.y(), p.z(), axisMask, (int)axis);
        }

        public void reset(BoundingBox boundingBox, double x, double y, double z, AxisMask axisMask, double axis) {
            this.reset(boundingBox, x, y, z, axisMask, (int)axis);
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.maxX && this.y <= this.maxY && this.z <= this.maxZ;
        }

        @Override
        public MutablePoint next() {
            this.point.set(this.x + this.sx, this.y + this.sy, this.z + this.sz);
            this.x += 1.0;
            if (this.x > this.maxX) {
                this.x = this.minX;
                this.y += 1.0;
                if (this.y > this.maxY) {
                    this.y = this.minY;
                    this.z += 1.0;
                }
            }
            return this.point;
        }
    }

    public static enum AxisMask {
        X,
        Y,
        Z,
        NONE;

    }

    public static class MutablePoint {
        double x;
        double y;
        double z;

        public void set(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double z() {
            return this.z;
        }

        public int blockX() {
            return (int)Math.floor(this.x);
        }

        public int blockY() {
            return (int)Math.floor(this.y);
        }

        public int blockZ() {
            return (int)Math.floor(this.z);
        }
    }
}

