/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.ItemStack;
import net.minestom.server.tag.Serializers;
import net.minestom.server.tag.TagRecord;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.utils.collection.AutoIncrementMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public class Tag<T> {
    private static final AutoIncrementMap<String> INDEX_MAP = new AutoIncrementMap();
    final int index;
    private final String key;
    final Serializers.Entry<T, BinaryTag> entry;
    private final Supplier<T> defaultValue;
    final Function<?, ?> readComparator;
    final PathEntry[] path;
    final UnaryOperator<T> copy;
    final int listScope;

    Tag(int index, String key, Function<?, ?> readComparator, Serializers.Entry<T, BinaryTag> entry, Supplier<T> defaultValue, PathEntry[] path, UnaryOperator<T> copy, int listScope) {
        assert (index == INDEX_MAP.get(key));
        this.index = index;
        this.key = key;
        this.readComparator = readComparator;
        this.entry = entry;
        this.defaultValue = defaultValue;
        this.path = path;
        this.copy = copy;
        this.listScope = listScope;
    }

    static <T, N extends BinaryTag> Tag<T> tag(@NotNull String key, @NotNull Serializers.Entry<T, N> entry) {
        return new Tag<T>(INDEX_MAP.get(key), key, entry.reader(), entry, null, null, null, 0);
    }

    static <T> Tag<T> fromSerializer(@NotNull String key, @NotNull TagSerializer<T> serializer) {
        if (serializer instanceof TagRecord.Serializer) {
            TagRecord.Serializer recordSerializer = (TagRecord.Serializer)serializer;
            return Tag.tag(key, recordSerializer.serializerEntry);
        }
        return Tag.tag(key, Serializers.fromTagSerializer(serializer));
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @Contract(value="_ -> new", pure=true)
    public Tag<T> defaultValue(@NotNull Supplier<T> defaultValue) {
        return new Tag<T>(this.index, this.key, this.readComparator, this.entry, defaultValue, this.path, this.copy, this.listScope);
    }

    @Contract(value="_ -> new", pure=true)
    public Tag<T> defaultValue(@NotNull T defaultValue) {
        return this.defaultValue((T)((Supplier<Object>)() -> defaultValue));
    }

    @Contract(value="_, _ -> new", pure=true)
    public <R> Tag<R> map(@NotNull Function<T, R> readMap, @NotNull Function<R, T> writeMap) {
        Serializers.Entry<T, BinaryTag> entry = this.entry;
        Function<BinaryTag, Object> readFunction = entry.reader().andThen(t -> {
            if (t == null) {
                return null;
            }
            return readMap.apply(t);
        });
        Function<R, BinaryTag> writeFunction = writeMap.andThen(entry.writer());
        return new Tag<Object>(this.index, this.key, readMap, new Serializers.Entry<Object, BinaryTag>(entry.nbtType(), readFunction, writeFunction), () -> {
            T defaultValue = this.createDefault();
            if (defaultValue == null) {
                return null;
            }
            return readMap.apply(defaultValue);
        }, this.path, null, this.listScope);
    }

    @Contract(value="-> new", pure=true)
    public Tag<List<T>> list() {
        Serializers.Entry<T, BinaryTag> entry = this.entry;
        Function readFunction = entry.reader();
        Function writeFunction = entry.writer();
        Serializers.Entry<List, ListBinaryTag> listEntry = new Serializers.Entry<List, ListBinaryTag>(BinaryTagTypes.LIST, read -> {
            if (read.size() == 0) {
                return List.of();
            }
            return read.stream().map(readFunction).toList();
        }, write -> {
            if (write.isEmpty()) {
                return ListBinaryTag.empty();
            }
            List list = write.stream().map(writeFunction).toList();
            BinaryTagType type = ((BinaryTag)list.get(0)).type();
            return ListBinaryTag.listBinaryTag((BinaryTagType)type, list);
        });
        UnaryOperator co = this.copy != null ? ts -> {
            int size = ts.size();
            Object[] array = new Object[size];
            boolean shallowCopy = true;
            for (int i = 0; i < size; ++i) {
                Object t = ts.get(i);
                Object copy = this.copy.apply(t);
                if (shallowCopy && copy != t) {
                    shallowCopy = false;
                }
                array[i] = copy;
            }
            return shallowCopy ? List.copyOf(ts) : List.of(array);
        } : List::copyOf;
        return new Tag<List<T>>(this.index, this.key, this.readComparator, (Serializers.Entry)Serializers.Entry.class.cast(listEntry), null, this.path, co, this.listScope + 1);
    }

    @Contract(value="_ -> new", pure=true)
    public Tag<T> path(String ... path) {
        if (path == null || path.length == 0) {
            return new Tag<T>(this.index, this.key, this.readComparator, this.entry, this.defaultValue, null, this.copy, this.listScope);
        }
        PathEntry[] pathEntries = new PathEntry[path.length];
        for (int i = 0; i < path.length; ++i) {
            String name = path[i];
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Path must not be empty: " + Arrays.toString(path));
            }
            pathEntries[i] = new PathEntry(name, INDEX_MAP.get(name));
        }
        return new Tag<T>(this.index, this.key, this.readComparator, this.entry, this.defaultValue, pathEntries, this.copy, this.listScope);
    }

    @Nullable
    public T read(@NotNull CompoundBinaryTag nbt) {
        CompoundBinaryTag readable = this.isView() ? nbt : nbt.get(this.key);
        try {
            T result;
            if (readable == null || (result = this.entry.read((BinaryTag)readable)) == null) {
                return this.createDefault();
            }
            return result;
        }
        catch (ClassCastException e) {
            return this.createDefault();
        }
    }

    public void write(@NotNull CompoundBinaryTag.Builder nbtCompound, @Nullable T value) {
        if (value != null) {
            BinaryTag nbt = this.entry.write(value);
            if (this.isView()) {
                nbtCompound.put((CompoundBinaryTag)nbt);
            } else {
                nbtCompound.put(this.key, nbt);
            }
        } else if (this.isView()) {
            nbtCompound.build().keySet().forEach(arg_0 -> ((CompoundBinaryTag.Builder)nbtCompound).remove(arg_0));
        } else {
            nbtCompound.remove(this.key);
        }
    }

    public void writeUnsafe(@NotNull CompoundBinaryTag.Builder nbtCompound, @Nullable Object value) {
        this.write(nbtCompound, value);
    }

    final boolean isView() {
        return this.key.isEmpty();
    }

    final boolean shareValue(@NotNull Tag<?> other) {
        if (this == other) {
            return true;
        }
        if (this.listScope != other.listScope) {
            return false;
        }
        return this.readComparator == other.readComparator;
    }

    final T createDefault() {
        Supplier<T> supplier = this.defaultValue;
        return supplier != null ? (T)supplier.get() : null;
    }

    final T copyValue(@NotNull T value) {
        UnaryOperator<T> copier = this.copy;
        return (T)(copier != null ? copier.apply(value) : value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        return this.index == tag.index && this.listScope == tag.listScope && this.readComparator.equals(tag.readComparator) && Objects.equals(this.defaultValue, tag.defaultValue) && Arrays.equals(this.path, tag.path) && Objects.equals(this.copy, tag.copy);
    }

    public int hashCode() {
        int result = Objects.hash(this.index, this.readComparator, this.defaultValue, this.copy, this.listScope);
        result = 31 * result + Arrays.hashCode(this.path);
        return result;
    }

    @NotNull
    public static Tag<Byte> Byte(@NotNull String key) {
        return Tag.tag(key, Serializers.BYTE);
    }

    @NotNull
    public static Tag<Boolean> Boolean(@NotNull String key) {
        return Tag.tag(key, Serializers.BOOLEAN);
    }

    @NotNull
    public static Tag<Short> Short(@NotNull String key) {
        return Tag.tag(key, Serializers.SHORT);
    }

    @NotNull
    public static Tag<Integer> Integer(@NotNull String key) {
        return Tag.tag(key, Serializers.INT);
    }

    @NotNull
    public static Tag<Long> Long(@NotNull String key) {
        return Tag.tag(key, Serializers.LONG);
    }

    @NotNull
    public static Tag<Float> Float(@NotNull String key) {
        return Tag.tag(key, Serializers.FLOAT);
    }

    @NotNull
    public static Tag<Double> Double(@NotNull String key) {
        return Tag.tag(key, Serializers.DOUBLE);
    }

    @NotNull
    public static Tag<String> String(@NotNull String key) {
        return Tag.tag(key, Serializers.STRING);
    }

    @NotNull
    public static Tag<UUID> UUID(@NotNull String key) {
        return Tag.tag(key, Serializers.UUID);
    }

    @NotNull
    public static Tag<ItemStack> ItemStack(@NotNull String key) {
        return Tag.tag(key, Serializers.ITEM);
    }

    @NotNull
    public static Tag<Component> Component(@NotNull String key) {
        return Tag.tag(key, Serializers.COMPONENT);
    }

    @NotNull
    public static Tag<BinaryTag> NBT(@NotNull String key) {
        return Tag.tag(key, Serializers.NBT_ENTRY);
    }

    @NotNull
    public static <T> Tag<T> Structure(@NotNull String key, @NotNull TagSerializer<T> serializer) {
        return Tag.fromSerializer(key, serializer);
    }

    @NotNull
    public static <T> Tag<T> View(@NotNull TagSerializer<T> serializer) {
        return Tag.Structure("", serializer);
    }

    @ApiStatus.Experimental
    @NotNull
    public static <T extends Record> Tag<T> Structure(@NotNull String key, @NotNull Class<T> type) {
        return Tag.Structure(key, TagRecord.serializer(type));
    }

    @ApiStatus.Experimental
    @NotNull
    public static <T extends Record> Tag<T> View(@NotNull Class<T> type) {
        return Tag.View(TagRecord.serializer(type));
    }

    @NotNull
    public static <T> Tag<T> Transient(@NotNull String key) {
        return Tag.tag(key, Serializers.EMPTY);
    }

    record PathEntry(String name, int index) {
    }
}

