/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import it.unimi.dsi.fastutil.shorts.ShortArrayFIFOQueue;
import java.util.Arrays;
import java.util.Objects;
import net.minestom.server.collision.Shape;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.NotNull;

public final class LightCompute {
    static final Direction[] DIRECTIONS = Direction.values();
    static final int LIGHT_LENGTH = 2048;
    static final int SECTION_SIZE = 16;
    public static final byte[] EMPTY_CONTENT = new byte[2048];
    public static final byte[] CONTENT_FULLY_LIT = new byte[2048];

    static byte @NotNull [] compute(Palette blockPalette, ShortArrayFIFOQueue lightPre) {
        short index;
        if (lightPre.isEmpty()) {
            return EMPTY_CONTENT;
        }
        byte[] lightArray = new byte[2048];
        ShortArrayFIFOQueue lightSources = new ShortArrayFIFOQueue();
        while (!lightPre.isEmpty()) {
            index = lightPre.dequeueShort();
            int newLightLevel = index >> 12 & 0xF;
            int newIndex = index & 0xFFF;
            int oldLightLevel = LightCompute.getLight(lightArray, newIndex);
            if (oldLightLevel >= newLightLevel) continue;
            LightCompute.placeLight(lightArray, newIndex, newLightLevel);
            lightSources.enqueue(index);
        }
        while (!lightSources.isEmpty()) {
            index = lightSources.dequeueShort();
            int x = index & 0xF;
            int z = index >> 4 & 0xF;
            int y = index >> 8 & 0xF;
            int lightLevel = index >> 12 & 0xF;
            byte newLightLevel = (byte)(lightLevel - 1);
            for (Direction direction : DIRECTIONS) {
                boolean airAir;
                int newIndex;
                int xO = x + direction.normalX();
                int yO = y + direction.normalY();
                int zO = z + direction.normalZ();
                if (xO < 0 || xO >= 16 || yO < 0 || yO >= 16 || zO < 0 || zO >= 16 || LightCompute.getLight(lightArray, newIndex = xO | zO << 4 | yO << 8) >= newLightLevel) continue;
                Block currentBlock = Objects.requireNonNullElse(Block.fromStateId((short)blockPalette.get(x, y, z)), Block.AIR);
                Block propagatedBlock = Objects.requireNonNullElse(Block.fromStateId((short)blockPalette.get(xO, yO, zO)), Block.AIR);
                Shape currentShape = currentBlock.registry().collisionShape();
                Shape propagatedShape = propagatedBlock.registry().collisionShape();
                boolean bl = airAir = currentBlock.isAir() && propagatedBlock.isAir();
                if (!airAir && currentShape.isOccluded(propagatedShape, BlockFace.fromDirection(direction))) continue;
                LightCompute.placeLight(lightArray, newIndex, newLightLevel);
                lightSources.enqueue((short)(newIndex | newLightLevel << 12));
            }
        }
        return lightArray;
    }

    private static void placeLight(byte[] light, int index, int value) {
        int shift = (index & 1) << 2;
        int i = index >>> 1;
        light[i] = (byte)(light[i] & 240 >>> shift | value << shift);
    }

    static int getLight(byte[] light, int x, int y, int z) {
        return LightCompute.getLight(light, x | z << 4 | y << 8);
    }

    static int getLight(byte[] light, int index) {
        if (index >>> 1 >= light.length) {
            return 0;
        }
        byte value = light[index >>> 1];
        return value >>> ((index & 1) << 2) & 0xF;
    }

    public static byte[] bake(byte[] content1, byte[] content2) {
        if (content1 == null && content2 == null) {
            return EMPTY_CONTENT;
        }
        if (content1 == EMPTY_CONTENT && content2 == EMPTY_CONTENT) {
            return EMPTY_CONTENT;
        }
        if (content1 == null) {
            return content2;
        }
        if (content2 == null) {
            return content1;
        }
        if (Arrays.equals(content1, EMPTY_CONTENT) && Arrays.equals(content2, EMPTY_CONTENT)) {
            return EMPTY_CONTENT;
        }
        byte[] lightMax = new byte[2048];
        for (int i = 0; i < content1.length; ++i) {
            byte c1 = content1[i];
            byte c2 = content2[i];
            byte l1 = (byte)(c1 & 0xF);
            byte l2 = (byte)(c2 & 0xF);
            byte u1 = (byte)(c1 >> 4 & 0xF);
            byte u2 = (byte)(c2 >> 4 & 0xF);
            byte lower = (byte)Math.max(l1, l2);
            byte upper = (byte)Math.max(u1, u2);
            lightMax[i] = (byte)(lower | upper << 4);
        }
        return lightMax;
    }

    static {
        Arrays.fill(CONTENT_FULLY_LIT, (byte)-1);
    }
}

