/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import java.util.Set;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.BlockLight;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.instance.light.SkyLight;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.ApiStatus;

public interface Light {
    public static Light sky() {
        return new SkyLight();
    }

    public static Light block() {
        return new BlockLight();
    }

    public boolean requiresSend();

    @ApiStatus.Internal
    public byte[] array();

    public Set<Point> flip();

    @ApiStatus.Internal
    public Light calculateExternal(Instance var1, Chunk var2, int var3, Palette var4);

    public int getLevel(int var1, int var2, int var3);

    @ApiStatus.Internal
    public Light calculateInternal(Instance var1, int var2, int var3, int var4, Palette var5);

    public void invalidate();

    public boolean requiresUpdate();

    public void set(byte[] var1);

    @ApiStatus.Internal
    public static Point[] getNeighbors(Chunk chunk, int sectionY) {
        int chunkX = chunk.getChunkX();
        int chunkZ = chunk.getChunkZ();
        Point[] links = new Vec[BlockFace.values().length];
        for (BlockFace face : BlockFace.values()) {
            Direction direction = face.toDirection();
            int x = chunkX + direction.normalX();
            int z = chunkZ + direction.normalZ();
            int y = sectionY + direction.normalY();
            Chunk foundChunk = chunk.getInstance().getChunk(x, z);
            if (foundChunk == null || y - foundChunk.getMinSection() > foundChunk.getMaxSection() || y - foundChunk.getMinSection() < 0) continue;
            links[face.ordinal()] = new Vec(foundChunk.getChunkX(), y, foundChunk.getChunkZ());
        }
        return links;
    }

    @ApiStatus.Internal
    public static boolean compareBorders(byte[] content, byte[] contentPropagation, byte[] contentPropagationTemp, BlockFace face) {
        if (content == null && contentPropagation == null && contentPropagationTemp == null) {
            return true;
        }
        int k = switch (face) {
            default -> throw new MatchException(null, null);
            case BlockFace.WEST, BlockFace.BOTTOM, BlockFace.NORTH -> 0;
            case BlockFace.EAST, BlockFace.TOP, BlockFace.SOUTH -> 15;
        };
        for (int bx = 0; bx < 16; ++bx) {
            for (int by = 0; by < 16; ++by) {
                int posFrom;
                switch (face) {
                    case NORTH: 
                    case SOUTH: {
                        int n = bx | k << 4 | by << 8;
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        int n = k | by << 4 | bx << 8;
                        break;
                    }
                    default: {
                        int n = posFrom = bx | by << 4 | k << 8;
                    }
                }
                int valueFrom = content == null && contentPropagation == null ? 0 : (content != null && contentPropagation == null ? LightCompute.getLight(content, posFrom) : (content == null ? LightCompute.getLight(contentPropagation, posFrom) : Math.max(LightCompute.getLight(content, posFrom), LightCompute.getLight(contentPropagation, posFrom))));
                int valueTo = LightCompute.getLight(contentPropagationTemp, posFrom);
                if (valueFrom >= valueTo) continue;
                return false;
            }
        }
        return true;
    }
}

