/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.light;

import it.unimi.dsi.fastutil.shorts.ShortArrayFIFOQueue;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.instance.palette.Palette;
import org.jetbrains.annotations.ApiStatus;

final class SkyLight
implements Light {
    private byte[] content;
    private byte[] contentPropagation;
    private byte[] contentPropagationSwap;
    private final AtomicBoolean isValidBorders = new AtomicBoolean(true);
    private final AtomicBoolean needsSend = new AtomicBoolean(false);
    private final Section[] neighborSections = new Section[BlockFace.values().length];
    private boolean fullyLit = false;

    SkyLight() {
    }

    @Override
    public void flip() {
        if (this.contentPropagationSwap != null) {
            this.contentPropagation = this.contentPropagationSwap;
        }
        this.contentPropagationSwap = null;
    }

    static ShortArrayFIFOQueue buildInternalQueue(int[] heightmap, int maxY, int sectionY) {
        ShortArrayFIFOQueue lightSources = new ShortArrayFIFOQueue();
        int sectionMaxY = (sectionY + 1) * 16 - 1;
        int sectionMinY = sectionY * 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = heightmap[z << 4 | x];
                for (int y = Math.min(sectionMaxY, maxY); y >= Math.max(height, sectionMinY); --y) {
                    int index = x | z << 4 | y % 16 << 8;
                    lightSources.enqueue((short)(index | 0xF000));
                }
            }
        }
        return lightSources;
    }

    private ShortArrayFIFOQueue buildExternalQueue(Instance instance, Palette blockPalette, Point[] neighbors, byte[] content) {
        ShortArrayFIFOQueue lightSources = new ShortArrayFIFOQueue();
        for (int i = 0; i < neighbors.length; ++i) {
            BlockFace face = BlockFace.values()[i];
            Point neighborSection = neighbors[i];
            if (neighborSection == null) continue;
            Section otherSection = this.neighborSections[face.ordinal()];
            if (otherSection == null) {
                Chunk chunk = instance.getChunk(neighborSection.blockX(), neighborSection.blockZ());
                if (chunk == null) continue;
                this.neighborSections[face.ordinal()] = otherSection = chunk.getSection(neighborSection.blockY());
            }
            Light otherLight = otherSection.skyLight();
            for (int bx = 0; bx < 16; ++bx) {
                for (int by = 0; by < 16; ++by) {
                    Block blockFrom;
                    byte internalEmission;
                    int posTo;
                    int k = switch (face) {
                        default -> throw new MatchException(null, null);
                        case BlockFace.WEST, BlockFace.BOTTOM, BlockFace.NORTH -> 0;
                        case BlockFace.EAST, BlockFace.TOP, BlockFace.SOUTH -> 15;
                    };
                    byte lightEmission = (byte)Math.max((switch (face) {
                        case BlockFace.NORTH, BlockFace.SOUTH -> (byte)otherLight.getLevel(bx, by, 15 - k);
                        case BlockFace.WEST, BlockFace.EAST -> (byte)otherLight.getLevel(15 - k, bx, by);
                        default -> (byte)otherLight.getLevel(bx, 15 - k, by);
                    }) - 1, 0);
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            int n = bx | k << 4 | by << 8;
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            int n = k | by << 4 | bx << 8;
                            break;
                        }
                        default: {
                            int n = posTo = bx | by << 4 | k << 8;
                        }
                    }
                    if (content != null && lightEmission <= (internalEmission = (byte)Math.max(LightCompute.getLight(content, posTo) - 1, 0))) continue;
                    Block blockTo = switch (face) {
                        case BlockFace.NORTH, BlockFace.SOUTH -> LightCompute.getBlock(blockPalette, bx, by, k);
                        case BlockFace.WEST, BlockFace.EAST -> LightCompute.getBlock(blockPalette, k, bx, by);
                        default -> LightCompute.getBlock(blockPalette, bx, k, by);
                    };
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            Block block = LightCompute.getBlock(otherSection.blockPalette(), bx, by, 15 - k);
                            break;
                        }
                        case WEST: 
                        case EAST: {
                            Block block = LightCompute.getBlock(otherSection.blockPalette(), 15 - k, bx, by);
                            break;
                        }
                        default: {
                            Block block = blockFrom = LightCompute.getBlock(otherSection.blockPalette(), bx, 15 - k, by);
                        }
                    }
                    if (blockTo == null && blockFrom != null ? blockFrom.registry().collisionShape().isOccluded(Block.AIR.registry().collisionShape(), face.getOppositeFace()) : (blockTo != null && blockFrom == null ? Block.AIR.registry().collisionShape().isOccluded(blockTo.registry().collisionShape(), face) : blockTo != null && blockFrom != null && blockFrom.registry().collisionShape().isOccluded(blockTo.registry().collisionShape(), face.getOppositeFace()))) continue;
                    int index = posTo | lightEmission << 12;
                    if (lightEmission <= 0) continue;
                    lightSources.enqueue((short)index);
                }
            }
        }
        return lightSources;
    }

    @Override
    public void invalidate() {
        this.needsSend.set(true);
        this.isValidBorders.set(false);
        this.contentPropagation = null;
    }

    @Override
    public boolean requiresUpdate() {
        return !this.isValidBorders.get();
    }

    @Override
    @ApiStatus.Internal
    public void set(byte[] copyArray) {
        this.content = (byte[])copyArray.clone();
        this.contentPropagation = this.content;
        this.isValidBorders.set(true);
        this.needsSend.set(true);
    }

    @Override
    public boolean requiresSend() {
        return this.needsSend.getAndSet(false);
    }

    @Override
    public byte[] array() {
        if (this.content == null) {
            return new byte[0];
        }
        if (this.contentPropagation == null) {
            return this.content;
        }
        byte[] res = LightCompute.bake(this.contentPropagation, this.content);
        if (res == LightCompute.EMPTY_CONTENT) {
            return new byte[0];
        }
        return res;
    }

    @Override
    public int getLevel(int x, int y, int z) {
        if (this.content == null) {
            return 0;
        }
        int index = x | z << 4 | y << 8;
        if (this.contentPropagation == null) {
            return LightCompute.getLight(this.content, index);
        }
        return Math.max(LightCompute.getLight(this.contentPropagation, index), LightCompute.getLight(this.content, index));
    }

    @Override
    public Set<Point> calculateInternal(Palette blockPalette, int chunkX, int chunkY, int chunkZ, int[] heightmap, int maxY, Light.NeighborLookup neighborLookup) {
        this.isValidBorders.set(true);
        int queueSize = 4096;
        ShortArrayFIFOQueue queue = new ShortArrayFIFOQueue(0);
        if (!this.fullyLit) {
            queue = SkyLight.buildInternalQueue(heightmap, maxY, chunkY);
            queueSize = queue.size();
        }
        if (queueSize == 4096) {
            this.fullyLit = true;
            this.content = LightCompute.CONTENT_FULLY_LIT;
        } else {
            this.content = LightCompute.compute(blockPalette, queue);
        }
        HashSet<Point> toUpdate = new HashSet<Point>();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    int neighborX = chunkX + i;
                    int neighborY = chunkY + j;
                    int neighborZ = chunkZ + k;
                    Light light = neighborLookup.light(neighborX, neighborY, neighborZ);
                    if (!(light instanceof SkyLight)) continue;
                    SkyLight skyLight = (SkyLight)light;
                    skyLight.contentPropagation = null;
                    toUpdate.add(new Vec(neighborX, neighborY, neighborZ));
                }
            }
        }
        toUpdate.add(new Vec(chunkX, chunkY, chunkZ));
        return toUpdate;
    }

    @Override
    public Set<Point> calculateExternal(Instance instance, Chunk chunk, int sectionY, Palette blockPalette) {
        if (!this.isValidBorders.get()) {
            return Set.of();
        }
        Point[] neighbors = Light.getNeighbors(chunk, sectionY);
        byte[] contentPropagationTemp = LightCompute.CONTENT_FULLY_LIT;
        if (!this.fullyLit) {
            ShortArrayFIFOQueue queue = this.buildExternalQueue(instance, blockPalette, neighbors, this.content);
            contentPropagationTemp = LightCompute.compute(blockPalette, queue);
            this.contentPropagationSwap = LightCompute.bake(this.contentPropagationSwap, contentPropagationTemp);
        } else {
            this.contentPropagationSwap = null;
        }
        HashSet<Point> toUpdate = new HashSet<Point>();
        for (int i = 0; i < neighbors.length; ++i) {
            BlockFace face;
            Point neighbor = neighbors[i];
            if (neighbor == null || LightCompute.compareBorders(this.content, this.contentPropagation, contentPropagationTemp, face = BlockFace.values()[i])) continue;
            toUpdate.add(neighbor);
        }
        return toUpdate;
    }
}

