/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.crypto;

import java.time.Instant;
import net.minestom.server.crypto.LastSeenMessages;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public final class SignedMessageBody {

    public record Packed(@NotNull String content, @NotNull Instant timeStamp, long salt, @NotNull LastSeenMessages.Packed lastSeen) implements NetworkBuffer.Writer
    {
        public Packed(@NotNull String content, @NotNull Instant timeStamp, long salt, LastSeenMessages.Packed lastSeen) {
            if (content.length() > 256) {
                throw new IllegalArgumentException("Message content too long");
            }
        }

        public Packed(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), Instant.ofEpochMilli(reader.read(NetworkBuffer.LONG)), reader.read(NetworkBuffer.LONG), new LastSeenMessages.Packed(reader));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.content);
            writer.write(NetworkBuffer.LONG, this.timeStamp.toEpochMilli());
            writer.write(NetworkBuffer.LONG, this.salt);
            writer.write(this.lastSeen);
        }
    }
}

