/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.chunk;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minestom.server.coordinate.CoordConversionUtils;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChunkUtils {
    private ChunkUtils() {
    }

    @NotNull
    public static CompletableFuture<Void> optionalLoadAll(@NotNull Instance instance, long @NotNull [] chunks, @Nullable Consumer<Chunk> eachCallback) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AtomicInteger counter = new AtomicInteger(0);
        for (long visibleChunk : chunks) {
            instance.loadOptionalChunk(CoordConversionUtils.chunkIndexToChunkX((long)visibleChunk), CoordConversionUtils.chunkIndexToChunkZ((long)visibleChunk)).thenAccept(chunk -> {
                if (eachCallback != null) {
                    eachCallback.accept((Chunk)chunk);
                }
                if (counter.incrementAndGet() == chunks.length) {
                    completableFuture.complete(null);
                }
            });
        }
        return completableFuture;
    }

    public static boolean isLoaded(@Nullable Chunk chunk) {
        return chunk != null && chunk.isLoaded();
    }

    public static boolean isLoaded(@NotNull Instance instance, double x, double z) {
        Chunk chunk = instance.getChunk(CoordConversionUtils.globalToChunk((double)x), CoordConversionUtils.globalToChunk((double)z));
        return ChunkUtils.isLoaded(chunk);
    }

    public static boolean isLoaded(@NotNull Instance instance, @NotNull Point point) {
        Chunk chunk = instance.getChunk(point.chunkX(), point.chunkZ());
        return ChunkUtils.isLoaded(chunk);
    }

    public static Chunk retrieve(Instance instance, Chunk originChunk, double x, double z) {
        int chunkX = CoordConversionUtils.globalToChunk((double)x);
        int chunkZ = CoordConversionUtils.globalToChunk((double)z);
        boolean sameChunk = originChunk != null && originChunk.getChunkX() == chunkX && originChunk.getChunkZ() == chunkZ;
        return sameChunk ? originChunk : instance.getChunk(chunkX, chunkZ);
    }

    public static Chunk retrieve(Instance instance, Chunk originChunk, Point position) {
        return ChunkUtils.retrieve(instance, originChunk, position.x(), position.z());
    }

    public static long getChunkIndex(@NotNull Chunk chunk) {
        return CoordConversionUtils.chunkIndex((int)chunk.getChunkX(), (int)chunk.getChunkZ());
    }
}

