/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.minestom.server.ObjectPools;
import net.minestom.server.ServerFlag;
import net.minestom.server.Viewable;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import net.minestom.server.utils.ObjectPool;
import net.minestom.server.utils.PacketSendingUtils;
import net.minestom.server.utils.PacketUtils;
import net.minestom.server.utils.binary.BinaryBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PacketViewableUtils {
    private static final Cache<Viewable, ViewableStorage> VIEWABLE_STORAGE_MAP = Caffeine.newBuilder().weakKeys().build();

    private PacketViewableUtils() {
    }

    @ApiStatus.Experimental
    public static void prepareViewablePacket(@NotNull Viewable viewable, @NotNull ServerPacket serverPacket, @Nullable Entity entity) {
        if (entity != null && !entity.hasPredictableViewers()) {
            entity.sendPacketToViewers(serverPacket);
            return;
        }
        if (!ServerFlag.VIEWABLE_PACKET) {
            PacketSendingUtils.sendGroupedPacket(viewable.getViewers(), serverPacket, value -> !Objects.equals(value, entity));
            return;
        }
        Player exception = entity instanceof Player ? (Player)entity : null;
        ViewableStorage storage = (ViewableStorage)VIEWABLE_STORAGE_MAP.get((Object)viewable, unused -> new ViewableStorage());
        storage.append(viewable, serverPacket, exception);
    }

    @ApiStatus.Experimental
    public static void prepareViewablePacket(@NotNull Viewable viewable, @NotNull ServerPacket serverPacket) {
        PacketViewableUtils.prepareViewablePacket(viewable, serverPacket, null);
    }

    @ApiStatus.Internal
    public static void flush() {
        if (ServerFlag.VIEWABLE_PACKET) {
            VIEWABLE_STORAGE_MAP.asMap().entrySet().parallelStream().forEach(entry -> ((ViewableStorage)entry.getValue()).process((Viewable)entry.getKey()));
        }
    }

    private static final class ViewableStorage {
        private final Int2ObjectMap<LongArrayList> entityIdMap = new Int2ObjectOpenHashMap();
        private final BinaryBuffer buffer = (BinaryBuffer)ObjectPools.BUFFER_POOL.getAndRegister((Object)this);

        private ViewableStorage() {
        }

        private synchronized void append(Viewable viewable, ServerPacket serverPacket, @Nullable Player exception) {
            try (ObjectPool.Holder hold = ObjectPools.PACKET_POOL.hold();){
                ByteBuffer framedPacket = PacketUtils.createFramedPacket(ConnectionState.PLAY, (ByteBuffer)hold.get(), serverPacket);
                int packetSize = framedPacket.limit();
                if (packetSize >= this.buffer.capacity()) {
                    this.process(viewable);
                    for (Player viewer : viewable.getViewers()) {
                        if (Objects.equals(exception, viewer)) continue;
                        ViewableStorage.writeTo(viewer.getPlayerConnection(), framedPacket, 0, packetSize);
                    }
                    return;
                }
                if (!this.buffer.canWrite(packetSize)) {
                    this.process(viewable);
                }
                int start = this.buffer.writerOffset();
                this.buffer.write(framedPacket);
                int end = this.buffer.writerOffset();
                if (exception != null) {
                    long offsets = (long)start << 32 | (long)end & 0xFFFFFFFFL;
                    LongList list = (LongList)this.entityIdMap.computeIfAbsent(exception.getEntityId(), id -> new LongArrayList());
                    list.add(offsets);
                }
            }
        }

        private synchronized void process(Viewable viewable) {
            if (this.buffer.writerOffset() == 0) {
                return;
            }
            ByteBuffer copy = ByteBuffer.allocateDirect(this.buffer.writerOffset());
            copy.put(this.buffer.asByteBuffer(0, copy.capacity()));
            viewable.getViewers().forEach(player -> this.processPlayer((Player)player, copy));
            this.buffer.clear();
            this.entityIdMap.clear();
        }

        private void processPlayer(Player player, ByteBuffer buffer) {
            int size = buffer.limit();
            PlayerConnection connection = player.getPlayerConnection();
            LongArrayList pairs = (LongArrayList)this.entityIdMap.get(player.getEntityId());
            if (pairs != null) {
                int lastWrite = 0;
                long[] elements = pairs.elements();
                for (int i = 0; i < pairs.size(); ++i) {
                    long offsets = elements[i];
                    int start = (int)(offsets >> 32);
                    if (start != lastWrite) {
                        ViewableStorage.writeTo(connection, buffer, lastWrite, start - lastWrite);
                    }
                    lastWrite = (int)offsets;
                }
                if (size != lastWrite) {
                    ViewableStorage.writeTo(connection, buffer, lastWrite, size - lastWrite);
                }
            } else {
                ViewableStorage.writeTo(connection, buffer, 0, size);
            }
        }

        private static void writeTo(PlayerConnection connection, ByteBuffer buffer, int offset, int length) {
            if (connection instanceof PlayerSocketConnection) {
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
                socketConnection.write(buffer, offset, length);
                return;
            }
        }
    }
}

