/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ObjectPools;
import net.minestom.server.ServerFlag;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.ObjectPool;
import net.minestom.server.utils.binary.BinaryBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PacketUtils {
    private static final ThreadLocal<Deflater> LOCAL_DEFLATER = ThreadLocal.withInitial(Deflater::new);

    private PacketUtils() {
    }

    static boolean shouldUseCachePacket(@NotNull ServerPacket packet) {
        if (!MinestomAdventure.AUTOMATIC_COMPONENT_TRANSLATION) {
            return ServerFlag.GROUPED_PACKET;
        }
        if (!(packet instanceof ServerPacket.ComponentHolding)) {
            return ServerFlag.GROUPED_PACKET;
        }
        ServerPacket.ComponentHolding holder = (ServerPacket.ComponentHolding)((Object)packet);
        return !PacketUtils.containsTranslatableComponents(holder);
    }

    private static boolean containsTranslatableComponents(@NotNull ComponentHolder<?> holder) {
        for (Component component : holder.components()) {
            if (!PacketUtils.isTranslatable(component)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTranslatable(@NotNull Component component) {
        if (component instanceof TranslatableComponent) {
            return true;
        }
        List children = component.children();
        if (children.isEmpty()) {
            return false;
        }
        for (Component child : children) {
            if (!PacketUtils.isTranslatable(child)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    public static BinaryBuffer readPackets(@NotNull BinaryBuffer readBuffer, boolean compressed, BiConsumer<Integer, ByteBuffer> payloadConsumer) throws DataFormatException {
        BinaryBuffer remaining = null;
        ByteBuffer pool = (ByteBuffer)ObjectPools.PACKET_POOL.get();
        while (readBuffer.readableBytes() > 0) {
            BinaryBuffer.Marker beginMark = readBuffer.mark();
            try {
                int packetLength = readBuffer.readVarInt();
                int readerStart = readBuffer.readerOffset();
                if (!readBuffer.canRead(packetLength)) {
                    throw new BufferUnderflowException();
                }
                BinaryBuffer content = readBuffer;
                int decompressedSize = packetLength;
                if (compressed) {
                    int dataLength = readBuffer.readVarInt();
                    int payloadLength = packetLength - (readBuffer.readerOffset() - readerStart);
                    if (payloadLength < 0) {
                        throw new DataFormatException("Negative payload length " + payloadLength);
                    }
                    if (dataLength == 0) {
                        decompressedSize = payloadLength;
                    } else {
                        content = BinaryBuffer.wrap(pool);
                        decompressedSize = dataLength;
                        Inflater inflater = new Inflater();
                        inflater.setInput(readBuffer.asByteBuffer(readBuffer.readerOffset(), payloadLength));
                        inflater.inflate(content.asByteBuffer(0, dataLength));
                        inflater.reset();
                    }
                }
                ByteBuffer payload = content.asByteBuffer(content.readerOffset(), decompressedSize);
                int packetId = PacketUtils.readVarInt(payload);
                try {
                    payloadConsumer.accept(packetId, payload);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                readBuffer.readerOffset(readerStart + packetLength);
            }
            catch (BufferUnderflowException e) {
                readBuffer.reset(beginMark);
                remaining = BinaryBuffer.copy(readBuffer);
                break;
            }
        }
        ObjectPools.PACKET_POOL.add((Object)pool);
        return remaining;
    }

    public static void writeFramedPacket(@NotNull ConnectionState state, @NotNull ByteBuffer buffer, @NotNull ServerPacket packet, boolean compression) {
        PacketUtils.writeFramedPacket(buffer, packet.getId(state), (NetworkBuffer.Writer)packet, compression ? MinecraftServer.getCompressionThreshold() : 0);
    }

    public static void writeFramedPacket(@NotNull ByteBuffer buffer, int id, @NotNull NetworkBuffer.Writer writer, int compressionThreshold) {
        boolean compressed;
        NetworkBuffer networkBuffer = new NetworkBuffer(buffer, false);
        if (compressionThreshold <= 0) {
            int lengthIndex = networkBuffer.skipWrite(3);
            networkBuffer.write(NetworkBuffer.VAR_INT, id);
            networkBuffer.write(writer);
            int finalSize = networkBuffer.writeIndex() - (lengthIndex + 3);
            PacketUtils.writeVarIntHeader(buffer, lengthIndex, finalSize);
            buffer.position(networkBuffer.writeIndex());
            return;
        }
        int compressedIndex = networkBuffer.skipWrite(3);
        int uncompressedIndex = networkBuffer.skipWrite(3);
        int contentStart = networkBuffer.writeIndex();
        networkBuffer.write(NetworkBuffer.VAR_INT, id);
        networkBuffer.write(writer);
        int packetSize = networkBuffer.writeIndex() - contentStart;
        boolean bl = compressed = packetSize >= compressionThreshold;
        if (compressed) {
            try (ObjectPool.Holder hold = ObjectPools.PACKET_POOL.hold();){
                ByteBuffer input = ((ByteBuffer)hold.get()).put(0, buffer, contentStart, packetSize);
                Deflater deflater = LOCAL_DEFLATER.get();
                deflater.setInput(input.limit(packetSize));
                deflater.finish();
                deflater.deflate(buffer.position(contentStart));
                deflater.reset();
                networkBuffer.skipWrite(buffer.position() - contentStart);
            }
        }
        PacketUtils.writeVarIntHeader(buffer, compressedIndex, networkBuffer.writeIndex() - uncompressedIndex);
        PacketUtils.writeVarIntHeader(buffer, uncompressedIndex, compressed ? packetSize : 0);
        buffer.position(networkBuffer.writeIndex());
    }

    @ApiStatus.Internal
    public static ByteBuffer createFramedPacket(@NotNull ConnectionState state, @NotNull ByteBuffer buffer, @NotNull ServerPacket packet, boolean compression) {
        PacketUtils.writeFramedPacket(state, buffer, packet, compression);
        return buffer.flip();
    }

    @ApiStatus.Internal
    public static ByteBuffer createFramedPacket(@NotNull ConnectionState state, @NotNull ByteBuffer buffer, @NotNull ServerPacket packet) {
        return PacketUtils.createFramedPacket(state, buffer, packet, MinecraftServer.getCompressionThreshold() > 0);
    }

    @ApiStatus.Internal
    public static FramedPacket allocateTrimmedPacket(@NotNull ConnectionState state, @NotNull ServerPacket packet) {
        try (ObjectPool.Holder hold = ObjectPools.PACKET_POOL.hold();){
            ByteBuffer temp = PacketUtils.createFramedPacket(state, (ByteBuffer)hold.get(), packet);
            int size = temp.remaining();
            ByteBuffer buffer = ByteBuffer.allocateDirect(size).put(0, temp, 0, size);
            FramedPacket framedPacket = new FramedPacket(packet, buffer);
            return framedPacket;
        }
    }

    @ApiStatus.Internal
    public static int invalidPacketState(@NotNull Class<?> packetClass, @NotNull ConnectionState state, ConnectionState ... expected) {
        assert (expected.length > 0) : "Expected states cannot be empty: " + String.valueOf(packetClass);
        StringBuilder expectedStr = new StringBuilder();
        for (ConnectionState connectionState : expected) {
            expectedStr.append(connectionState).append(", ");
        }
        expectedStr.delete(expectedStr.length() - 2, expectedStr.length());
        throw new IllegalStateException(String.format("Packet %s is not valid in state %s (only %s)", packetClass.getSimpleName(), state, expectedStr));
    }

    public static void writeVarIntHeader(@NotNull ByteBuffer buffer, int startIndex, int value) {
        buffer.put(startIndex, (byte)(value & 0x7F | 0x80));
        buffer.put(startIndex + 1, (byte)(value >>> 7 & 0x7F | 0x80));
        buffer.put(startIndex + 2, (byte)(value >>> 14));
    }

    public static int readVarInt(ByteBuffer buf) {
        int result = 0;
        int shift = 0;
        while (true) {
            byte b = buf.get();
            result |= (b & 0x7F) << shift;
            if (b >= 0) {
                return result;
            }
            shift += 7;
        }
    }
}

