/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.util.Collection;
import java.util.function.Predicate;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public final class PacketSendingUtils {
    private PacketSendingUtils() {
    }

    public static void sendPacket(@NotNull Audience audience, @NotNull ServerPacket packet) {
        if (audience instanceof Player) {
            Player player = (Player)audience;
            player.sendPacket(packet);
        } else if (audience instanceof PacketGroupingAudience) {
            PacketGroupingAudience groupingAudience = (PacketGroupingAudience)audience;
            PacketSendingUtils.sendGroupedPacket(groupingAudience.getPlayers(), packet);
        } else if (audience instanceof ForwardingAudience.Single) {
            ForwardingAudience.Single singleAudience = (ForwardingAudience.Single)audience;
            PacketSendingUtils.sendPacket(singleAudience.audience(), packet);
        } else if (audience instanceof ForwardingAudience) {
            ForwardingAudience forwardingAudience = (ForwardingAudience)audience;
            for (Audience member : forwardingAudience.audiences()) {
                PacketSendingUtils.sendPacket(member, packet);
            }
        }
    }

    public static void sendGroupedPacket(@NotNull Collection<Player> players, @NotNull ServerPacket packet, @NotNull Predicate<Player> predicate) {
        SendablePacket sendablePacket = PacketUtils.shouldUseCachePacket(packet) ? new CachedPacket(packet) : packet;
        players.forEach(player -> {
            if (predicate.test((Player)player)) {
                player.sendPacket(sendablePacket);
            }
        });
    }

    public static void sendGroupedPacket(@NotNull Collection<Player> players, @NotNull ServerPacket packet) {
        PacketSendingUtils.sendGroupedPacket(players, packet, player -> true);
    }

    public static void broadcastPlayPacket(@NotNull ServerPacket packet) {
        PacketSendingUtils.sendGroupedPacket(MinecraftServer.getConnectionManager().getOnlinePlayers(), packet);
    }
}

