/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.util.Collection;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static boolean isEmpty(@Nullable Object @NotNull [] array) {
        for (Object object : array) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int[] mapToIntArray(Collection<T> collection, ToIntFunction<T> function) {
        int size = collection.size();
        if (size == 0) {
            return new int[0];
        }
        int[] result = new int[size];
        int i = 0;
        for (T object : collection) {
            result[i++] = function.applyAsInt(object);
        }
        assert (i == size);
        return result;
    }
}

