/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.timer;

import java.time.Duration;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import net.minestom.server.MinecraftServer;

public final class Tick
implements TemporalUnit {
    public static Tick SERVER_TICKS = new Tick(MinecraftServer.TICK_MS);
    public static Tick CLIENT_TICKS = new Tick(50L);
    private final long milliseconds;
    private final int tps;

    private Tick(long length) {
        if (length <= 0L) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        this.milliseconds = length;
        this.tps = Math.toIntExact(Duration.ofSeconds(1L).dividedBy(Duration.ofMillis(this.milliseconds)));
    }

    public static Duration server(long ticks) {
        return Duration.of(ticks, SERVER_TICKS);
    }

    public static Duration client(long ticks) {
        return Duration.of(ticks, CLIENT_TICKS);
    }

    public int fromDuration(Duration duration) {
        return Math.toIntExact(duration.dividedBy(this.getDuration()));
    }

    public int getTicksPerSecond() {
        return this.tps;
    }

    @Override
    public Duration getDuration() {
        return Duration.ofMillis(this.milliseconds);
    }

    @Override
    public boolean isDurationEstimated() {
        return false;
    }

    @Override
    public boolean isDateBased() {
        return false;
    }

    @Override
    public boolean isTimeBased() {
        return true;
    }

    @Override
    public <R extends Temporal> R addTo(R temporal, long amount) {
        return (R)temporal.plus(amount, this);
    }

    @Override
    public long between(Temporal start, Temporal end) {
        return start.until(end, this);
    }
}

