/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.IntFunction;
import net.minestom.server.Tickable;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.AcquirableSource;
import net.minestom.server.thread.ThreadProvider;
import net.minestom.server.thread.TickThread;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class ThreadDispatcher<P> {
    private final ThreadProvider<P> provider;
    private final List<TickThread> threads;
    private final Map<P, Partition> partitions = new WeakHashMap<P, Partition>();
    private final Map<Tickable, Partition> elements = new WeakHashMap<Tickable, Partition>();
    private final ArrayDeque<P> partitionUpdateQueue = new ArrayDeque();
    private final MessagePassingQueue<DispatchUpdate<P>> updates = new MpscUnboundedArrayQueue(1024);

    private ThreadDispatcher(ThreadProvider<P> provider, int threadCount, @NotNull IntFunction<? extends TickThread> threadGenerator) {
        this.provider = provider;
        TickThread[] threads = new TickThread[threadCount];
        Arrays.setAll(threads, threadGenerator);
        this.threads = List.of(threads);
        this.threads.forEach(Thread::start);
    }

    @NotNull
    public static <P> ThreadDispatcher<P> of(@NotNull ThreadProvider<P> provider, int threadCount) {
        return new ThreadDispatcher<P>(provider, threadCount, TickThread::new);
    }

    @NotNull
    public static <P> ThreadDispatcher<P> of(@NotNull ThreadProvider<P> provider, @NotNull IntFunction<String> nameGenerator, int threadCount) {
        return new ThreadDispatcher<P>(provider, threadCount, index -> new TickThread((String)nameGenerator.apply(index)));
    }

    @NotNull
    public static <P> ThreadDispatcher<P> singleThread() {
        return ThreadDispatcher.of(ThreadProvider.counter(), 1);
    }

    @ApiStatus.Internal
    @NotNull
    public @Unmodifiable @NotNull List<@NotNull TickThread> threads() {
        return this.threads;
    }

    public synchronized void updateAndAwait(long time) {
        this.updates.drain(update -> {
            DispatchUpdate selector0$temp = update;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DispatchUpdate.PartitionLoad.class, DispatchUpdate.PartitionUnload.class, DispatchUpdate.ElementUpdate.class, DispatchUpdate.ElementRemove.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    DispatchUpdate.PartitionLoad chunkUpdate = (DispatchUpdate.PartitionLoad)selector0$temp;
                    this.processLoadedPartition(chunkUpdate.partition());
                    break;
                }
                case 1: {
                    DispatchUpdate.PartitionUnload partitionUnload = (DispatchUpdate.PartitionUnload)selector0$temp;
                    this.processUnloadedPartition(partitionUnload.partition());
                    break;
                }
                case 2: {
                    DispatchUpdate.ElementUpdate elementUpdate = (DispatchUpdate.ElementUpdate)selector0$temp;
                    this.processUpdatedElement(elementUpdate.tickable(), elementUpdate.partition());
                    break;
                }
                case 3: {
                    DispatchUpdate.ElementRemove elementRemove = (DispatchUpdate.ElementRemove)selector0$temp;
                    this.processRemovedElement(elementRemove.tickable());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown update type: " + (update == null ? "null" : update.getClass().getSimpleName()));
                }
            }
        });
        CountDownLatch latch = new CountDownLatch(this.threads.size());
        for (TickThread thread : this.threads) {
            thread.startTick(latch, time);
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void refreshThreads(long nanoTimeout) {
        block0 : switch (this.provider.refreshType()) {
            case NEVER: {
                break;
            }
            case ALWAYS: {
                P partition;
                long currentTime = System.nanoTime();
                int counter = this.partitionUpdateQueue.size();
                while ((partition = this.partitionUpdateQueue.pollFirst()) != null) {
                    Partition partitionEntry = this.partitions.get(partition);
                    assert (partitionEntry != null);
                    TickThread previous = partitionEntry.thread;
                    TickThread next = this.retrieveThread(partition);
                    if (next != previous) {
                        partitionEntry.thread = next;
                        previous.entries().remove(partitionEntry);
                        next.entries().add(partitionEntry);
                    }
                    this.partitionUpdateQueue.addLast(partition);
                    if (--counter > 0 && System.nanoTime() - currentTime < nanoTimeout) continue;
                    break block0;
                }
                break;
            }
        }
    }

    public void refreshThreads() {
        this.refreshThreads(Long.MAX_VALUE);
    }

    public void createPartition(@NotNull P partition) {
        this.signalUpdate(new DispatchUpdate.PartitionLoad<P>(partition));
    }

    public void deletePartition(@NotNull P partition) {
        this.signalUpdate(new DispatchUpdate.PartitionUnload<P>(partition));
    }

    public void updateElement(@NotNull Tickable tickable, @NotNull P partition) {
        this.signalUpdate(new DispatchUpdate.ElementUpdate<P>(tickable, partition));
    }

    public void removeElement(@NotNull Tickable tickable) {
        this.signalUpdate(new DispatchUpdate.ElementRemove(tickable));
    }

    public void shutdown() {
        this.threads.forEach(TickThread::shutdown);
    }

    private TickThread retrieveThread(P partition) {
        int threadId = this.provider.findThread(partition);
        int index = Math.abs(threadId) % this.threads.size();
        return this.threads.get(index);
    }

    private void signalUpdate(@NotNull DispatchUpdate<P> update) {
        this.updates.relaxedOffer(update);
    }

    private void processLoadedPartition(P partition) {
        if (this.partitions.containsKey(partition)) {
            return;
        }
        TickThread thread = this.retrieveThread(partition);
        Partition partitionEntry = new Partition(thread);
        thread.entries().add(partitionEntry);
        this.partitions.put(partition, partitionEntry);
        this.partitionUpdateQueue.add(partition);
        if (partition instanceof Tickable) {
            Tickable tickable = (Tickable)partition;
            this.processUpdatedElement(tickable, partition);
        }
    }

    private void processUnloadedPartition(P partition) {
        Partition partitionEntry = this.partitions.remove(partition);
        if (partitionEntry != null) {
            TickThread thread = partitionEntry.thread;
            thread.entries().remove(partitionEntry);
        }
        this.partitionUpdateQueue.remove(partition);
        if (partition instanceof Tickable) {
            Tickable tickable = (Tickable)partition;
            this.processRemovedElement(tickable);
        }
    }

    private void processRemovedElement(Tickable tickable) {
        Partition partition = this.elements.get(tickable);
        if (partition != null) {
            partition.elements.remove(tickable);
        }
    }

    private void processUpdatedElement(Tickable tickable, P partition) {
        Partition partitionEntry = this.elements.get(tickable);
        if (partitionEntry != null) {
            partitionEntry.elements.remove(tickable);
        }
        if ((partitionEntry = this.partitions.get(partition)) != null) {
            this.elements.put(tickable, partitionEntry);
            partitionEntry.elements.add(tickable);
            if (tickable instanceof AcquirableSource) {
                AcquirableSource acquirableSource = (AcquirableSource)((Object)tickable);
                ((AcquirableImpl)acquirableSource.acquirable()).updateThread(partitionEntry.thread());
            }
        }
    }

    public static final class Partition {
        private TickThread thread;
        private final List<Tickable> elements = new ArrayList<Tickable>();

        private Partition(TickThread thread) {
            this.thread = thread;
        }

        @ApiStatus.Internal
        @NotNull
        public TickThread thread() {
            return this.thread;
        }

        @NotNull
        public List<Tickable> elements() {
            return this.elements;
        }
    }

    @ApiStatus.Internal
    static sealed interface DispatchUpdate<P> {

        public record ElementRemove<P>(@NotNull Tickable tickable) implements DispatchUpdate<P>
        {
        }

        public record ElementUpdate<P>(@NotNull Tickable tickable, P partition) implements DispatchUpdate<P>
        {
        }

        public record PartitionUnload<P>(@NotNull P partition) implements DispatchUpdate<P>
        {
        }

        public record PartitionLoad<P>(@NotNull P partition) implements DispatchUpdate<P>
        {
        }
    }
}

