/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.concurrent.locks.ReentrantLock;
import net.minestom.server.thread.AcquirableImpl;
import net.minestom.server.thread.TickThread;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public final class Acquired<T> {
    private final T value;
    private final Thread owner;
    private final ReentrantLock lock;
    private boolean unlocked;

    Acquired(T value, TickThread tickThread) {
        this.value = value;
        this.owner = Thread.currentThread();
        this.lock = AcquirableImpl.enter(this.owner, tickThread);
    }

    @NotNull
    public T get() {
        this.safeCheck();
        return this.value;
    }

    public void unlock() {
        this.safeCheck();
        this.unlocked = true;
        AcquirableImpl.leave(this.lock);
    }

    private void safeCheck() {
        Check.stateCondition((Thread.currentThread() != this.owner ? 1 : 0) != 0, (String)"Acquired object is owned by the thread {0}", (Object[])new Object[]{this.owner});
        Check.stateCondition((boolean)this.unlocked, (String)"The acquired element has already been unlocked!");
    }
}

