/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.scoreboard;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.play.TeamsPacket;
import net.minestom.server.utils.PacketSendingUtils;
import org.jetbrains.annotations.NotNull;

public class Team
implements PacketGroupingAudience {
    private static final byte ALLOW_FRIENDLY_FIRE_BIT = 1;
    private static final byte SEE_INVISIBLE_PLAYERS_BIT = 2;
    private final Set<String> members;
    private final String teamName;
    private Component teamDisplayName;
    private byte friendlyFlags;
    private TeamsPacket.NameTagVisibility nameTagVisibility;
    private TeamsPacket.CollisionRule collisionRule;
    private NamedTextColor teamColor;
    private Component prefix;
    private Component suffix;
    private final Set<Player> playerMembers = ConcurrentHashMap.newKeySet();
    private boolean isPlayerMembersUpToDate;
    private final Pointers pointers;

    protected Team(@NotNull String teamName) {
        this.teamName = teamName;
        this.teamDisplayName = Component.empty();
        this.friendlyFlags = 0;
        this.nameTagVisibility = TeamsPacket.NameTagVisibility.ALWAYS;
        this.collisionRule = TeamsPacket.CollisionRule.ALWAYS;
        this.teamColor = NamedTextColor.WHITE;
        this.prefix = Component.empty();
        this.suffix = Component.empty();
        this.members = new CopyOnWriteArraySet<String>();
        this.pointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, this::getTeamName).withDynamic(Identity.DISPLAY_NAME, this::getTeamDisplayName).build();
    }

    public void addMember(@NotNull String member) {
        this.addMembers(List.of(member));
    }

    public void addMembers(@NotNull @NotNull Collection<@NotNull String> toAdd) {
        this.members.addAll(toAdd);
        TeamsPacket addPlayerPacket = new TeamsPacket(this.teamName, new TeamsPacket.AddEntitiesToTeamAction(toAdd));
        PacketSendingUtils.broadcastPlayPacket(addPlayerPacket);
        this.isPlayerMembersUpToDate = false;
    }

    public void removeMember(@NotNull String member) {
        this.removeMembers(List.of(member));
    }

    public void removeMembers(@NotNull @NotNull Collection<@NotNull String> toRemove) {
        TeamsPacket removePlayerPacket = new TeamsPacket(this.teamName, new TeamsPacket.RemoveEntitiesToTeamAction(toRemove));
        PacketSendingUtils.broadcastPlayPacket(removePlayerPacket);
        this.members.removeAll(toRemove);
        this.isPlayerMembersUpToDate = false;
    }

    public void setTeamDisplayName(Component teamDisplayName) {
        this.teamDisplayName = teamDisplayName;
    }

    public void updateTeamDisplayName(Component teamDisplayName) {
        this.setTeamDisplayName(teamDisplayName);
        this.sendUpdatePacket();
    }

    public void setNameTagVisibility(@NotNull TeamsPacket.NameTagVisibility visibility) {
        this.nameTagVisibility = visibility;
    }

    public void updateNameTagVisibility(@NotNull TeamsPacket.NameTagVisibility nameTagVisibility) {
        this.setNameTagVisibility(nameTagVisibility);
        this.sendUpdatePacket();
    }

    public void setCollisionRule(@NotNull TeamsPacket.CollisionRule rule) {
        this.collisionRule = rule;
    }

    public void updateCollisionRule(@NotNull TeamsPacket.CollisionRule collisionRule) {
        this.setCollisionRule(collisionRule);
        this.sendUpdatePacket();
    }

    public void setTeamColor(@NotNull NamedTextColor color) {
        this.teamColor = color;
    }

    public void updateTeamColor(@NotNull NamedTextColor color) {
        this.setTeamColor(color);
        this.sendUpdatePacket();
    }

    public void setPrefix(Component prefix) {
        this.prefix = prefix;
    }

    public void updatePrefix(Component prefix) {
        this.setPrefix(prefix);
        this.sendUpdatePacket();
    }

    public void setSuffix(Component suffix) {
        this.suffix = suffix;
    }

    public void updateSuffix(Component suffix) {
        this.setSuffix(suffix);
        this.sendUpdatePacket();
    }

    public void setFriendlyFlags(byte flag) {
        this.friendlyFlags = flag;
    }

    public void updateFriendlyFlags(byte flag) {
        this.setFriendlyFlags(flag);
        this.sendUpdatePacket();
    }

    private boolean getFriendlyFlagBit(byte index) {
        return (this.friendlyFlags & index) == index;
    }

    private void setFriendlyFlagBit(byte index, boolean value) {
        this.friendlyFlags = value ? (byte)(this.friendlyFlags | index) : (byte)(this.friendlyFlags & ~index);
    }

    public void setAllowFriendlyFire(boolean value) {
        this.setFriendlyFlagBit((byte)1, value);
    }

    public void updateAllowFriendlyFire(boolean value) {
        this.setAllowFriendlyFire(value);
        this.sendUpdatePacket();
    }

    public boolean isAllowFriendlyFire() {
        return this.getFriendlyFlagBit((byte)1);
    }

    public void setSeeInvisiblePlayers(boolean value) {
        this.setFriendlyFlagBit((byte)2, value);
    }

    public void updateSeeInvisiblePlayers(boolean value) {
        this.setSeeInvisiblePlayers(value);
        this.sendUpdatePacket();
    }

    public boolean isSeeInvisiblePlayers() {
        return this.getFriendlyFlagBit((byte)2);
    }

    public String getTeamName() {
        return this.teamName;
    }

    @NotNull
    public TeamsPacket createTeamsCreationPacket() {
        TeamsPacket.CreateTeamAction info = new TeamsPacket.CreateTeamAction(this.teamDisplayName, this.friendlyFlags, this.nameTagVisibility, this.collisionRule, this.teamColor, this.prefix, this.suffix, this.members);
        return new TeamsPacket(this.teamName, info);
    }

    @NotNull
    public TeamsPacket createTeamDestructionPacket() {
        return new TeamsPacket(this.teamName, new TeamsPacket.RemoveTeamAction());
    }

    @NotNull
    public Set<String> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    public Component getTeamDisplayName() {
        return this.teamDisplayName;
    }

    public byte getFriendlyFlags() {
        return this.friendlyFlags;
    }

    @NotNull
    public TeamsPacket.NameTagVisibility getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @NotNull
    public TeamsPacket.CollisionRule getCollisionRule() {
        return this.collisionRule;
    }

    @NotNull
    public NamedTextColor getTeamColor() {
        return this.teamColor;
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public Component getSuffix() {
        return this.suffix;
    }

    public void sendUpdatePacket() {
        TeamsPacket.UpdateTeamAction info = new TeamsPacket.UpdateTeamAction(this.teamDisplayName, this.friendlyFlags, this.nameTagVisibility, this.collisionRule, this.teamColor, this.prefix, this.suffix);
        PacketSendingUtils.broadcastPlayPacket(new TeamsPacket(this.teamName, info));
    }

    @Override
    @NotNull
    public Collection<Player> getPlayers() {
        if (!this.isPlayerMembersUpToDate) {
            this.playerMembers.clear();
            for (String member : this.members) {
                Player player = MinecraftServer.getConnectionManager().getOnlinePlayerByUsername(member);
                if (player == null) continue;
                this.playerMembers.add(player);
            }
            this.isPlayerMembersUpToDate = true;
        }
        return this.playerMembers;
    }

    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }
}

