/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.recipe.RecipeCategory;
import net.minestom.server.recipe.RecipeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Recipe
extends NetworkBuffer.Writer {
    public static final int MAX_INGREDIENTS = 128;

    @NotNull
    public String id();

    @NotNull
    public RecipeType type();

    public record Ingredient(@Nullable List<ItemStack> items) implements NetworkBuffer.Writer
    {
        public Ingredient(@Nullable List<ItemStack> items) {
            items = items == null ? null : List.copyOf(items);
        }

        public Ingredient(@NotNull NetworkBuffer reader) {
            this(reader.readCollection(ItemStack.STRICT_NETWORK_TYPE, 128));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeCollection(ItemStack.STRICT_NETWORK_TYPE, this.items);
        }
    }

    public record SmithingTrim(String id, Ingredient template, Ingredient base, Ingredient addition) implements Recipe
    {
        public SmithingTrim(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, new Ingredient(reader), new Ingredient(reader), new Ingredient(reader));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(this.template);
            writer.write(this.base);
            writer.write(this.addition);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.SMITHING_TRIM;
        }
    }

    public record SmithingTransform(String id, Ingredient template, Ingredient base, Ingredient addition, ItemStack result) implements Recipe
    {
        public SmithingTransform(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, new Ingredient(reader), new Ingredient(reader), new Ingredient(reader), reader.read(ItemStack.STRICT_NETWORK_TYPE));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(this.template);
            writer.write(this.base);
            writer.write(this.addition);
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.SMITHING_TRANSFORM;
        }
    }

    public record Stonecutting(String id, String group, Ingredient ingredient, ItemStack result) implements Recipe
    {
        public Stonecutting(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, reader.read(NetworkBuffer.STRING), new Ingredient(reader), reader.read(ItemStack.STRICT_NETWORK_TYPE));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.write(this.ingredient);
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.STONECUTTING;
        }
    }

    public record CampfireCooking(String id, String group, RecipeCategory.Cooking category, Ingredient ingredient, ItemStack result, float experience, int cookingTime) implements Recipe
    {
        public CampfireCooking(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(ItemStack.STRICT_NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.CAMPFIRE_COOKING;
        }
    }

    public record Smoking(String id, String group, RecipeCategory.Cooking category, Ingredient ingredient, ItemStack result, float experience, int cookingTime) implements Recipe
    {
        public Smoking(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(ItemStack.STRICT_NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.SMOKING;
        }
    }

    public record Blasting(String id, String group, RecipeCategory.Cooking category, Ingredient ingredient, ItemStack result, float experience, int cookingTime) implements Recipe
    {
        public Blasting(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(ItemStack.STRICT_NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.BLASTING;
        }
    }

    public record Smelting(String id, String group, RecipeCategory.Cooking category, Ingredient ingredient, ItemStack result, float experience, int cookingTime) implements Recipe
    {
        public Smelting(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Cooking.class), new Ingredient(reader), reader.read(ItemStack.STRICT_NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Cooking.class, this.category);
            writer.write(this.ingredient);
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.experience));
            writer.write(NetworkBuffer.VAR_INT, this.cookingTime);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.SMELTING;
        }
    }

    public record Shapeless(String id, String group, RecipeCategory.Crafting category, List<Ingredient> ingredients, ItemStack result) implements Recipe
    {
        public Shapeless(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(id, reader.read(NetworkBuffer.STRING), reader.readEnum(RecipeCategory.Crafting.class), reader.readCollection(Ingredient::new, 128), reader.read(ItemStack.STRICT_NETWORK_TYPE));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Crafting.class, this.category);
            writer.writeCollection(this.ingredients);
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.SHAPELESS;
        }
    }

    public record Shaped(String id, String group, RecipeCategory.Crafting category, int width, int height, List<Ingredient> ingredients, ItemStack result, boolean showNotification) implements Recipe
    {
        public Shaped {
            if (ingredients.size() != width * height) {
                throw new IllegalArgumentException("Invalid shaped recipe, ingredients size must be equal to width * height");
            }
            ingredients = List.copyOf(ingredients);
        }

        private Shaped(Shaped packet) {
            this(packet.id, packet.group, packet.category, packet.width, packet.height, packet.ingredients, packet.result, packet.showNotification);
        }

        public Shaped(@NotNull String id, @NotNull NetworkBuffer reader) {
            this(Shaped.read(id, reader));
        }

        private static Shaped read(@NotNull String id, @NotNull NetworkBuffer reader) {
            String group = reader.read(NetworkBuffer.STRING);
            RecipeCategory.Crafting category = reader.readEnum(RecipeCategory.Crafting.class);
            int width = reader.read(NetworkBuffer.VAR_INT);
            int height = reader.read(NetworkBuffer.VAR_INT);
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int slot = 0; slot < width * height; ++slot) {
                ingredients.add(new Ingredient(reader));
            }
            ItemStack result = reader.read(ItemStack.STRICT_NETWORK_TYPE);
            boolean showNotification = reader.read(NetworkBuffer.BOOLEAN);
            return new Shaped(id, group, category, width, height, ingredients, result, showNotification);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.group);
            writer.writeEnum(RecipeCategory.Crafting.class, this.category);
            writer.write(NetworkBuffer.VAR_INT, this.width);
            writer.write(NetworkBuffer.VAR_INT, this.height);
            for (Ingredient ingredient : this.ingredients) {
                ingredient.write(writer);
            }
            writer.write(ItemStack.STRICT_NETWORK_TYPE, this.result);
            writer.write(NetworkBuffer.BOOLEAN, this.showNotification);
        }

        @Override
        @NotNull
        public RecipeType type() {
            return RecipeType.SHAPED;
        }
    }
}

