/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.potion;

import java.util.Collection;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.potion.PotionEffectImpl;
import net.minestom.server.potion.PotionEffects;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface PotionEffect
extends StaticProtocolObject,
PotionEffects
permits PotionEffectImpl {
    public static final NetworkBuffer.Type<PotionEffect> NETWORK_TYPE = NetworkBuffer.VAR_INT.map(PotionEffectImpl::getId, PotionEffect::id);

    @Contract(pure=true)
    @NotNull
    public Registry.PotionEffectEntry registry();

    @NotNull
    default public NamespaceID namespace() {
        return this.registry().namespace();
    }

    default public int id() {
        return this.registry().id();
    }

    @NotNull
    public static @NotNull Collection<@NotNull PotionEffect> values() {
        return PotionEffectImpl.values();
    }

    @Nullable
    public static PotionEffect fromNamespaceId(@NotNull String namespaceID) {
        return PotionEffectImpl.getSafe(namespaceID);
    }

    @Nullable
    public static PotionEffect fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return PotionEffect.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static PotionEffect fromId(int id) {
        return PotionEffectImpl.getId(id);
    }
}

