/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.network.packet.server.play.data.WorldPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record JoinGamePacket(int entityId, boolean isHardcore, List<String> worlds, int maxPlayers, int viewDistance, int simulationDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, boolean doLimitedCrafting, int dimensionType, String world, long hashedSeed, GameMode gameMode, GameMode previousGameMode, boolean isDebug, boolean isFlat, @Nullable WorldPos deathLocation, int portalCooldown, boolean enforcesSecureChat) implements ServerPacket.Play
{
    public static final int MAX_WORLDS = Short.MAX_VALUE;

    public JoinGamePacket(int entityId, boolean isHardcore, List<String> worlds, int maxPlayers, int viewDistance, int simulationDistance, boolean reducedDebugInfo, boolean enableRespawnScreen, boolean doLimitedCrafting, int dimensionType, String world, long hashedSeed, GameMode gameMode, GameMode previousGameMode, boolean isDebug, boolean isFlat, @Nullable WorldPos deathLocation, int portalCooldown, boolean enforcesSecureChat) {
        worlds = List.copyOf(worlds);
    }

    public JoinGamePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.INT), reader.read(NetworkBuffer.BOOLEAN), reader.readCollection(NetworkBuffer.STRING, Short.MAX_VALUE), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), GameMode.fromId((int)reader.read(NetworkBuffer.BYTE).byteValue()), JoinGamePacket.getNullableGameMode(reader.read(NetworkBuffer.BYTE)), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.readOptional(WorldPos.NETWORK_TYPE), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.entityId);
        writer.write(NetworkBuffer.BOOLEAN, this.isHardcore);
        writer.writeCollection(NetworkBuffer.STRING, this.worlds);
        writer.write(NetworkBuffer.VAR_INT, this.maxPlayers);
        writer.write(NetworkBuffer.VAR_INT, this.viewDistance);
        writer.write(NetworkBuffer.VAR_INT, this.simulationDistance);
        writer.write(NetworkBuffer.BOOLEAN, this.reducedDebugInfo);
        writer.write(NetworkBuffer.BOOLEAN, this.enableRespawnScreen);
        writer.write(NetworkBuffer.BOOLEAN, this.doLimitedCrafting);
        writer.write(NetworkBuffer.VAR_INT, this.dimensionType);
        writer.write(NetworkBuffer.STRING, this.world);
        writer.write(NetworkBuffer.LONG, this.hashedSeed);
        writer.write(NetworkBuffer.BYTE, this.gameMode.id());
        if (this.previousGameMode != null) {
            writer.write(NetworkBuffer.BYTE, this.previousGameMode.id());
        } else {
            writer.write(NetworkBuffer.BYTE, (byte)-1);
        }
        writer.write(NetworkBuffer.BOOLEAN, this.isDebug);
        writer.write(NetworkBuffer.BOOLEAN, this.isFlat);
        writer.writeOptional(WorldPos.NETWORK_TYPE, this.deathLocation);
        writer.write(NetworkBuffer.VAR_INT, this.portalCooldown);
        writer.write(NetworkBuffer.BOOLEAN, this.enforcesSecureChat);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.JOIN_GAME;
    }

    @Nullable
    private static GameMode getNullableGameMode(byte id) {
        return id == -1 ? null : GameMode.fromId((int)id);
    }
}

