/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.particle.Particle;
import net.minestom.server.sound.SoundEvent;
import org.jetbrains.annotations.NotNull;

public record ExplosionPacket(double x, double y, double z, float radius, byte @NotNull [] records, float playerMotionX, float playerMotionY, float playerMotionZ, @NotNull BlockInteraction blockInteraction, int smallParticleId, byte @NotNull [] smallParticleData, int largeParticleId, byte @NotNull [] largeParticleData, @NotNull SoundEvent sound) implements ServerPacket.Play
{
    public static final SoundEvent DEFAULT_SOUND = SoundEvent.ENTITY_GENERIC_EXPLODE;

    public ExplosionPacket(@NotNull NetworkBuffer reader) {
        this(ExplosionPacket.fromReader(reader));
    }

    public ExplosionPacket(double x, double y, double z, float radius, byte @NotNull [] records, float playerMotionX, float playerMotionY, float playerMotionZ) {
        this(x, y, z, radius, records, playerMotionX, playerMotionY, playerMotionZ, BlockInteraction.DESTROY, Particle.EXPLOSION.id(), new byte[0], Particle.EXPLOSION_EMITTER.id(), new byte[0], DEFAULT_SOUND);
    }

    private ExplosionPacket(@NotNull ExplosionPacket packet) {
        this(packet.x, packet.y, packet.z, packet.radius, packet.records, packet.playerMotionX, packet.playerMotionY, packet.playerMotionZ, packet.blockInteraction, packet.smallParticleId, packet.smallParticleData, packet.largeParticleId, packet.largeParticleData, packet.sound);
    }

    @NotNull
    private static ExplosionPacket fromReader(@NotNull NetworkBuffer reader) {
        double x = reader.read(NetworkBuffer.DOUBLE);
        double y = reader.read(NetworkBuffer.DOUBLE);
        double z = reader.read(NetworkBuffer.DOUBLE);
        float radius = reader.read(NetworkBuffer.FLOAT).floatValue();
        byte[] records = reader.readBytes(reader.read(NetworkBuffer.VAR_INT) * 3);
        float playerMotionX = reader.read(NetworkBuffer.FLOAT).floatValue();
        float playerMotionY = reader.read(NetworkBuffer.FLOAT).floatValue();
        float playerMotionZ = reader.read(NetworkBuffer.FLOAT).floatValue();
        BlockInteraction blockInteraction = reader.readEnum(BlockInteraction.class);
        int smallParticleId = reader.read(NetworkBuffer.VAR_INT);
        byte[] smallParticleData = ExplosionPacket.readParticleData(reader, Particle.fromId(smallParticleId));
        int largeParticleId = reader.read(NetworkBuffer.VAR_INT);
        byte[] largeParticleData = ExplosionPacket.readParticleData(reader, Particle.fromId(largeParticleId));
        SoundEvent sound = reader.read(SoundEvent.NETWORK_TYPE);
        return new ExplosionPacket(x, y, z, radius, records, playerMotionX, playerMotionY, playerMotionZ, blockInteraction, smallParticleId, smallParticleData, largeParticleId, largeParticleData, sound);
    }

    private static byte @NotNull [] readParticleData(@NotNull NetworkBuffer reader, Particle particle) {
        return NetworkBuffer.makeArray(buffer -> {
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    if (!particle.equals(Particle.BLOCK) && !particle.equals(Particle.BLOCK_MARKER) && !particle.equals(Particle.FALLING_DUST) && !particle.equals(Particle.SHRIEK)) break block2;
                                    buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                    break block3;
                                }
                                if (!particle.equals(Particle.VIBRATION)) break block4;
                                buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                buffer.write(NetworkBuffer.BLOCK_POSITION, reader.read(NetworkBuffer.BLOCK_POSITION));
                                buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                                buffer.write(NetworkBuffer.VAR_INT, reader.read(NetworkBuffer.VAR_INT));
                                break block3;
                            }
                            if (!particle.equals(Particle.SCULK_CHARGE)) break block5;
                            buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                            break block3;
                        }
                        if (!particle.equals(Particle.ITEM)) break block6;
                        buffer.write(ItemStack.NETWORK_TYPE, reader.read(ItemStack.NETWORK_TYPE));
                        break block3;
                    }
                    if (!particle.equals(Particle.DUST_COLOR_TRANSITION)) break block7;
                    for (int i = 0; i < 7; ++i) {
                        buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                    }
                    break block3;
                }
                if (!particle.equals(Particle.DUST)) break block3;
                for (int i = 0; i < 4; ++i) {
                    buffer.write(NetworkBuffer.FLOAT, reader.read(NetworkBuffer.FLOAT));
                }
            }
        });
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.DOUBLE, this.x);
        writer.write(NetworkBuffer.DOUBLE, this.y);
        writer.write(NetworkBuffer.DOUBLE, this.z);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.radius));
        writer.write(NetworkBuffer.VAR_INT, this.records.length / 3);
        writer.write(NetworkBuffer.RAW_BYTES, this.records);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.playerMotionX));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.playerMotionY));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.playerMotionZ));
        writer.write(NetworkBuffer.VAR_INT, this.blockInteraction.ordinal());
        writer.write(NetworkBuffer.VAR_INT, this.smallParticleId);
        writer.write(NetworkBuffer.RAW_BYTES, this.smallParticleData);
        writer.write(NetworkBuffer.VAR_INT, this.largeParticleId);
        writer.write(NetworkBuffer.RAW_BYTES, this.largeParticleData);
        writer.write(SoundEvent.NETWORK_TYPE, this.sound);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.EXPLOSION;
    }

    public static enum BlockInteraction {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY,
        TRIGGER_BLOCK;

    }
}

