/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.configuration;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record SelectKnownPacksPacket(@NotNull List<Entry> entries) implements ServerPacket.Configuration
{
    private static final int MAX_ENTRIES = 64;
    public static final Entry MINECRAFT_CORE = new Entry("minecraft", "core", "1.21");

    public SelectKnownPacksPacket(@NotNull List<Entry> entries) {
        Check.argCondition((entries.size() > 64 ? 1 : 0) != 0, (String)"Too many known packs: {0} > {1}", (Object[])new Object[]{entries.size(), 64});
        entries = List.copyOf(entries);
    }

    public SelectKnownPacksPacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(Entry::new, 64));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.entries);
    }

    @Override
    public int configurationId() {
        return ServerPacketIdentifier.CONFIGURATION_SELECT_KNOWN_PACKS;
    }

    public record Entry(@NotNull String namespace, @NotNull String id, @NotNull String version) implements NetworkBuffer.Writer
    {
        public Entry(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.namespace);
            writer.write(NetworkBuffer.STRING, this.id);
            writer.write(NetworkBuffer.STRING, this.version);
        }
    }
}

