/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.common;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ServerLinksPacket(@NotNull List<Entry> entries) implements ServerPacket.Configuration,
ServerPacket.Play
{
    private static final int MAX_ENTRIES = 100;

    public ServerLinksPacket(@NotNull List<Entry> entries) {
        entries = List.copyOf(entries);
    }

    public ServerLinksPacket(Entry ... entries) {
        this(List.of(entries));
    }

    public ServerLinksPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(Entry.LIST_NETWORK_TYPE));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(Entry.LIST_NETWORK_TYPE, this.entries);
    }

    @Override
    public int configurationId() {
        return ServerPacketIdentifier.CONFIGURATION_SERVER_LINKS;
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.SERVER_LINKS;
    }

    public record Entry(@Nullable KnownLinkType knownType, @Nullable Component customType, @NotNull String link) {
        public static final NetworkBuffer.Type<Entry> NETWORK_TYPE = new NetworkBuffer.Type<Entry>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Entry value) {
                buffer.write(NetworkBuffer.BOOLEAN, value.knownType != null);
                if (value.knownType != null) {
                    buffer.write(KnownLinkType.NETWORK_TYPE, value.knownType);
                } else {
                    assert (value.customType != null);
                    buffer.write(NetworkBuffer.COMPONENT, value.customType);
                }
                buffer.write(NetworkBuffer.STRING, value.link);
            }

            @Override
            public Entry read(@NotNull NetworkBuffer buffer) {
                boolean known = buffer.read(NetworkBuffer.BOOLEAN);
                if (known) {
                    return new Entry(buffer.read(KnownLinkType.NETWORK_TYPE), buffer.read(NetworkBuffer.STRING));
                }
                return new Entry(buffer.read(NetworkBuffer.COMPONENT), buffer.read(NetworkBuffer.STRING));
            }
        };
        public static final NetworkBuffer.Type<List<Entry>> LIST_NETWORK_TYPE = NETWORK_TYPE.list(100);

        public Entry(@Nullable KnownLinkType knownType, @Nullable Component customType, @NotNull String link) {
            Check.argCondition((knownType == null && customType == null ? 1 : 0) != 0, (String)"One of knownType and customType must be present");
            Check.argCondition((knownType != null && customType != null ? 1 : 0) != 0, (String)"Only one of knownType and customType may be present");
        }

        public Entry(@NotNull KnownLinkType type, @NotNull String link) {
            this(type, null, link);
        }

        public Entry(@NotNull Component type, @NotNull String link) {
            this(null, type, link);
        }
    }

    public static enum KnownLinkType {
        BUG_REPORT,
        COMMUNITY_GUIDELINES,
        SUPPORT,
        STATUS,
        FEEDBACK,
        COMMUNITY,
        WEBSITE,
        FORUMS,
        NEWS,
        ANNOUNCEMENTS;

        public static final NetworkBuffer.Type<KnownLinkType> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(KnownLinkType.class);
        }
    }
}

