/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.configuration;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.server.configuration.SelectKnownPacksPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record ClientSelectKnownPacksPacket(@NotNull List<SelectKnownPacksPacket.Entry> entries) implements ClientPacket
{
    private static final int MAX_ENTRIES = 64;

    public ClientSelectKnownPacksPacket(@NotNull List<SelectKnownPacksPacket.Entry> entries) {
        Check.argCondition((entries.size() > 64 ? 1 : 0) != 0, (String)"Too many known packs: {0} > {1}", (Object[])new Object[]{entries.size(), 64});
        entries = List.copyOf(entries);
    }

    public ClientSelectKnownPacksPacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(SelectKnownPacksPacket.Entry::new, 64));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.entries);
    }
}

