/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.common;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ClientCookieResponsePacket(@NotNull String key, byte @Nullable [] value) implements ClientPacket
{
    public ClientCookieResponsePacket(@NotNull String key, byte[] value) {
        Check.argCondition((value != null && value.length > 5120 ? 1 : 0) != 0, (String)"Value is too long: {0} > {1}", (Object[])new Object[]{value != null ? value.length : 0, 5120});
    }

    public ClientCookieResponsePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.readOptional(buffer -> {
            int valueLength = buffer.read(NetworkBuffer.VAR_INT);
            Check.argCondition((valueLength > 5120 ? 1 : 0) != 0, (String)"Value is too long: {0} > {1}", (Object[])new Object[]{valueLength, 5120});
            return buffer.readBytes(valueLength);
        }));
    }

    @Override
    public boolean processImmediately() {
        return true;
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.key);
        writer.writeOptional(NetworkBuffer.BYTE_ARRAY, this.value);
    }
}

