/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.nio.ByteBuffer;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.packet.client.ClientPacketsHandler;
import net.minestom.server.network.packet.client.handshake.ClientHandshakePacket;
import org.jetbrains.annotations.NotNull;

public record PacketParser(ClientPacketsHandler statusHandler, ClientPacketsHandler loginHandler, ClientPacketsHandler configurationHandler, ClientPacketsHandler playHandler) {
    public PacketParser() {
        this(new ClientPacketsHandler.Status(), new ClientPacketsHandler.Login(), new ClientPacketsHandler.Configuration(), new ClientPacketsHandler.Play());
    }

    @NotNull
    public ClientPacket parse(@NotNull ConnectionState connectionState, int packetId, @NotNull ByteBuffer body) {
        NetworkBuffer buffer = new NetworkBuffer(body);
        ClientPacket clientPacket = switch (connectionState) {
            default -> throw new MatchException(null, null);
            case ConnectionState.HANDSHAKE -> {
                if (!$assertionsDisabled && packetId != 0) {
                    throw new AssertionError();
                }
                yield new ClientHandshakePacket(buffer);
            }
            case ConnectionState.STATUS -> this.statusHandler.create(packetId, buffer);
            case ConnectionState.LOGIN -> this.loginHandler.create(packetId, buffer);
            case ConnectionState.CONFIGURATION -> this.configurationHandler.create(packetId, buffer);
            case ConnectionState.PLAY -> this.playHandler.create(packetId, buffer);
        };
        body.position(buffer.readIndex());
        return clientPacket;
    }
}

