/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.message;

import net.minestom.server.message.ChatTypeDecoration;
import net.minestom.server.message.ChatTypeImpl;
import net.minestom.server.message.ChatTypes;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ChatType
extends ProtocolObject,
ChatTypes
permits ChatTypeImpl {
    @NotNull
    public static ChatType create(@NotNull ChatTypeDecoration chat, @NotNull ChatTypeDecoration narration) {
        return new ChatTypeImpl(chat, narration, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<ChatType> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:chat_type", ChatTypeImpl.REGISTRY_NBT_TYPE, Registry.Resource.CHAT_TYPES, (namespace, props) -> new ChatTypeImpl(Registry.chatType(namespace, props)));
    }

    @NotNull
    public ChatTypeDecoration chat();

    @NotNull
    public ChatTypeDecoration narration();

    @Nullable
    public Registry.ChatTypeEntry registry();

    public static final class Builder {
        private ChatTypeDecoration chat;
        private ChatTypeDecoration narration;

        private Builder() {
        }

        public Builder chat(@NotNull ChatTypeDecoration chat) {
            this.chat = chat;
            return this;
        }

        public Builder narration(@NotNull ChatTypeDecoration narration) {
            this.narration = narration;
            return this;
        }

        @NotNull
        public ChatType build() {
            return new ChatTypeImpl(this.chat, this.narration, null);
        }
    }
}

