/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityAttackEvent;
import net.minestom.server.event.player.PlayerEntityInteractEvent;
import net.minestom.server.network.packet.client.play.ClientInteractEntityPacket;

public class UseEntityListener {
    public static void useEntityListener(ClientInteractEntityPacket packet, Player player) {
        Entity entity = player.getInstance().getEntityById(packet.targetId());
        if (entity == null || !entity.isViewer(player) || player.getDistanceSquared(entity) > 36.0) {
            return;
        }
        ClientInteractEntityPacket.Type type = packet.type();
        if (type instanceof ClientInteractEntityPacket.Attack) {
            if (entity instanceof LivingEntity && ((LivingEntity)entity).isDead()) {
                return;
            }
            EventDispatcher.call(new EntityAttackEvent(player, entity));
        } else if (type instanceof ClientInteractEntityPacket.InteractAt) {
            ClientInteractEntityPacket.InteractAt interactAt = (ClientInteractEntityPacket.InteractAt)type;
            Vec interactPosition = new Vec((double)interactAt.targetX(), (double)interactAt.targetY(), (double)interactAt.targetZ());
            EventDispatcher.call(new PlayerEntityInteractEvent(player, entity, interactAt.hand(), (Point)interactPosition));
        }
    }
}

