/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.entity.EquipmentSlotGroup;
import net.minestom.server.item.Material;
import net.minestom.server.item.enchant.AttributeEffect;
import net.minestom.server.item.enchant.ConditionalEffect;
import net.minestom.server.item.enchant.DamageImmunityEffect;
import net.minestom.server.item.enchant.EnchantmentImpl;
import net.minestom.server.item.enchant.Enchantments;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.TargetedConditionalEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ObjectSet;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Enchantment
extends ProtocolObject,
Enchantments
permits EnchantmentImpl {
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<Enchantment>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::enchantment);
    @NotNull
    public static final BinaryTagSerializer<DynamicRegistry.Key<Enchantment>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::enchantment);

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<Enchantment> createDefaultRegistry(@NotNull Registries registries) {
        return DynamicRegistry.create("minecraft:enchantment", EnchantmentImpl.REGISTRY_NBT_TYPE, registries, Registry.Resource.ENCHANTMENTS);
    }

    @NotNull
    public Component description();

    @NotNull
    public ObjectSet<Enchantment> exclusiveSet();

    @NotNull
    public ObjectSet<Material> supportedItems();

    @NotNull
    public ObjectSet<Material> primaryItems();

    public int weight();

    public int maxLevel();

    @NotNull
    public Cost minCost();

    @NotNull
    public Cost maxCost();

    public int anvilCost();

    @NotNull
    public List<EquipmentSlotGroup> slots();

    @NotNull
    public DataComponentMap effects();

    @Nullable
    public Registry.EnchantmentEntry registry();

    public static class Builder {
        private Component description = Component.empty();
        private ObjectSet<Enchantment> exclusiveSet = ObjectSet.empty();
        private ObjectSet<Material> supportedItems = ObjectSet.empty();
        private ObjectSet<Material> primaryItems = ObjectSet.empty();
        private int weight = 1;
        private int maxLevel = 1;
        private Cost minCost = Cost.DEFAULT;
        private Cost maxCost = Cost.DEFAULT;
        private int anvilCost = 0;
        private List<EquipmentSlotGroup> slots = List.of();
        private DataComponentMap.Builder effects = DataComponentMap.builder();

        private Builder() {
        }

        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @NotNull
        public Builder exclusiveSet(@NotNull ObjectSet<Enchantment> exclusiveSet) {
            this.exclusiveSet = exclusiveSet;
            return this;
        }

        @NotNull
        public Builder supportedItems(@NotNull ObjectSet<Material> supportedItems) {
            this.supportedItems = supportedItems;
            return this;
        }

        @NotNull
        public Builder primaryItems(@NotNull ObjectSet<Material> primaryItems) {
            this.primaryItems = primaryItems;
            return this;
        }

        @NotNull
        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        @NotNull
        public Builder maxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
            return this;
        }

        @NotNull
        public Builder minCost(int base, int perLevelAboveFirst) {
            return this.minCost(new Cost(base, perLevelAboveFirst));
        }

        @NotNull
        public Builder minCost(@NotNull Cost minCost) {
            this.minCost = minCost;
            return this;
        }

        @NotNull
        public Builder maxCost(int base, int perLevelAboveFirst) {
            return this.maxCost(new Cost(base, perLevelAboveFirst));
        }

        @NotNull
        public Builder maxCost(@NotNull Cost maxCost) {
            this.maxCost = maxCost;
            return this;
        }

        @NotNull
        public Builder anvilCost(int anvilCost) {
            this.anvilCost = anvilCost;
            return this;
        }

        @NotNull
        public Builder slots(EquipmentSlotGroup ... slots) {
            this.slots = List.of(slots);
            return this;
        }

        @NotNull
        public Builder slots(@NotNull List<EquipmentSlotGroup> slots) {
            this.slots = slots;
            return this;
        }

        @NotNull
        public <T> Builder effect(@NotNull DataComponent<T> component, @NotNull T value) {
            this.effects.set(component, value);
            return this;
        }

        @NotNull
        public Builder effects(@NotNull DataComponentMap effects) {
            this.effects = effects.toBuilder();
            return this;
        }

        @NotNull
        public Enchantment build() {
            return new EnchantmentImpl(this.description, this.exclusiveSet, this.supportedItems, this.primaryItems, this.weight, this.maxLevel, this.minCost, this.maxCost, this.anvilCost, this.slots, this.effects.build(), null);
        }
    }

    public record Cost(int base, int perLevelAboveFirst) {
        public static final Cost DEFAULT = new Cost(1, 1);
        public static final BinaryTagSerializer<Cost> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> new Cost(tag.getInt("base"), tag.getInt("per_level_above_first")), cost -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putInt("base", cost.base)).putInt("per_level_above_first", cost.perLevelAboveFirst)).build());
    }

    public static sealed interface Effect
    permits AttributeEffect, ConditionalEffect, DamageImmunityEffect, EntityEffect, LocationEffect, TargetedConditionalEffect, ValueEffect {
    }

    public static enum Target {
        ATTACKER,
        DAMAGING_ENTITY,
        VICTIM;

        public static final BinaryTagSerializer<Target> NBT_TYPE;

        static {
            NBT_TYPE = BinaryTagSerializer.fromEnumStringable(Target.class);
        }
    }
}

