/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimMaterialImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface TrimMaterial
extends ProtocolObject
permits TrimMaterialImpl {
    @NotNull
    public static final NetworkBuffer.Type<DynamicRegistry.Key<TrimMaterial>> NETWORK_TYPE = NetworkBuffer.RegistryKey(Registries::trimMaterial);
    @NotNull
    public static final BinaryTagSerializer<DynamicRegistry.Key<TrimMaterial>> NBT_TYPE = BinaryTagSerializer.registryKey(Registries::trimMaterial);

    @NotNull
    public static TrimMaterial create(@NotNull String assetName, @NotNull Material ingredient, float itemModelIndex, @NotNull Map<String, String> overrideArmorMaterials, @NotNull Component description) {
        return new TrimMaterialImpl(assetName, ingredient, itemModelIndex, overrideArmorMaterials, description, null);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<TrimMaterial> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:trim_material", TrimMaterialImpl.REGISTRY_NBT_TYPE, Registry.Resource.TRIM_MATERIALS, (namespace, props) -> new TrimMaterialImpl(Registry.trimMaterial(namespace, props)));
    }

    @NotNull
    public String assetName();

    @NotNull
    public Material ingredient();

    public float itemModelIndex();

    @NotNull
    public Map<String, String> overrideArmorMaterials();

    @NotNull
    public Component description();

    @Contract(pure=true)
    @Nullable
    public Registry.TrimMaterialEntry registry();

    public static final class Builder {
        private String assetName;
        private Material ingredient;
        private float itemModelIndex;
        private final Map<String, String> overrideArmorMaterials = new HashMap<String, String>();
        private Component description;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetName(@NotNull String assetName) {
            this.assetName = assetName;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder ingredient(@NotNull Material ingredient) {
            this.ingredient = ingredient;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder itemModelIndex(float itemModelIndex) {
            this.itemModelIndex = itemModelIndex;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder overrideArmorMaterials(@NotNull Map<String, String> overrideArmorMaterials) {
            this.overrideArmorMaterials.putAll(overrideArmorMaterials);
            return this;
        }

        @Contract(value="_, _ -> this", pure=true)
        @NotNull
        public Builder overrideArmorMaterial(@NotNull String slot, @NotNull String material) {
            this.overrideArmorMaterials.put(slot, material);
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder description(@NotNull Component description) {
            this.description = description;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public TrimMaterial build() {
            return new TrimMaterialImpl(this.assetName, this.ingredient, this.itemModelIndex, this.overrideArmorMaterials, this.description, null);
        }
    }
}

