/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.List;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.item.EntityEquipEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.EquipmentHandler;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.SetSlotPacket;
import net.minestom.server.network.packet.server.play.WindowItemsPacket;
import net.minestom.server.utils.SlotUtils;
import org.jetbrains.annotations.NotNull;

public non-sealed class PlayerInventory
extends AbstractInventory
implements EquipmentHandler {
    public static final int INVENTORY_SIZE = 46;
    public static final int INNER_INVENTORY_SIZE = 36;
    protected final Player player;
    private ItemStack cursorItem = ItemStack.AIR;

    public PlayerInventory(@NotNull Player player) {
        super(46);
        this.player = player;
    }

    @Override
    public synchronized void clear() {
        this.cursorItem = ItemStack.AIR;
        super.clear();
        this.player.sendPacketToViewersAndSelf(this.player.getEquipmentsPacket());
    }

    @Override
    public int getInnerSize() {
        return 36;
    }

    @Override
    @NotNull
    public ItemStack getItemInMainHand() {
        return this.getItemStack(this.player.getHeldSlot());
    }

    @Override
    public void setItemInMainHand(@NotNull ItemStack itemStack) {
        this.safeItemInsert(this.player.getHeldSlot(), itemStack);
    }

    @Override
    @NotNull
    public ItemStack getItemInOffHand() {
        return this.getItemStack(45);
    }

    @Override
    public void setItemInOffHand(@NotNull ItemStack itemStack) {
        this.safeItemInsert(45, itemStack);
    }

    @Override
    @NotNull
    public ItemStack getHelmet() {
        return this.getItemStack(41);
    }

    @Override
    public void setHelmet(@NotNull ItemStack itemStack) {
        this.safeItemInsert(41, itemStack);
    }

    @Override
    @NotNull
    public ItemStack getChestplate() {
        return this.getItemStack(42);
    }

    @Override
    public void setChestplate(@NotNull ItemStack itemStack) {
        this.safeItemInsert(42, itemStack);
    }

    @Override
    @NotNull
    public ItemStack getLeggings() {
        return this.getItemStack(43);
    }

    @Override
    public void setLeggings(@NotNull ItemStack itemStack) {
        this.safeItemInsert(43, itemStack);
    }

    @Override
    @NotNull
    public ItemStack getBoots() {
        return this.getItemStack(44);
    }

    @Override
    public void setBoots(@NotNull ItemStack itemStack) {
        this.safeItemInsert(44, itemStack);
    }

    @Override
    public void update() {
        this.player.sendPacket(this.createWindowItemsPacket());
    }

    @NotNull
    public ItemStack getCursorItem() {
        return this.cursorItem;
    }

    public void setCursorItem(@NotNull ItemStack cursorItem) {
        if (this.cursorItem.equals(cursorItem)) {
            return;
        }
        this.cursorItem = cursorItem;
        SetSlotPacket setSlotPacket = SetSlotPacket.createCursorPacket(cursorItem);
        this.player.sendPacket(setSlotPacket);
    }

    @Override
    protected void UNSAFE_itemInsert(int slot, @NotNull ItemStack itemStack, boolean sendPacket) {
        EquipmentSlot equipmentSlot;
        switch (slot) {
            case 41: {
                Object object = EquipmentSlot.HELMET;
                break;
            }
            case 42: {
                Object object = EquipmentSlot.CHESTPLATE;
                break;
            }
            case 43: {
                Object object = EquipmentSlot.LEGGINGS;
                break;
            }
            case 44: {
                Object object = EquipmentSlot.BOOTS;
                break;
            }
            case 45: {
                Object object = EquipmentSlot.OFF_HAND;
                break;
            }
            default: {
                Object object = equipmentSlot = slot == this.player.getHeldSlot() ? EquipmentSlot.MAIN_HAND : null;
            }
        }
        if (equipmentSlot != null) {
            EntityEquipEvent entityEquipEvent = new EntityEquipEvent(this.player, itemStack, equipmentSlot);
            EventDispatcher.call(entityEquipEvent);
            itemStack = entityEquipEvent.getEquippedItem();
        }
        this.itemStacks[slot] = itemStack;
        if (sendPacket) {
            if (equipmentSlot != null) {
                this.player.syncEquipment(equipmentSlot);
            }
            this.sendSlotRefresh((short)SlotUtils.convertToPacketSlot((int)slot), itemStack);
        }
    }

    protected void sendSlotRefresh(short slot, ItemStack itemStack) {
        Inventory openInventory = this.player.getOpenInventory();
        if (openInventory != null && slot >= 9 && slot < 45) {
            this.player.sendPacket(new SetSlotPacket(openInventory.getWindowId(), 0, (short)(slot + openInventory.getSize() - 9), itemStack));
        } else if (openInventory == null || slot == 45) {
            this.player.sendPacket(new SetSlotPacket(0, 0, slot, itemStack));
        }
    }

    private WindowItemsPacket createWindowItemsPacket() {
        ItemStack[] convertedSlots = new ItemStack[46];
        for (int i = 0; i < this.itemStacks.length; ++i) {
            int slot = SlotUtils.convertToPacketSlot((int)i);
            convertedSlots[slot] = this.itemStacks[i];
        }
        return new WindowItemsPacket(0, 0, List.of(convertedSlots), this.cursorItem);
    }

    @Override
    public boolean leftClick(@NotNull Player player, int slot) {
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.leftClick(player, this, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, null, convertedSlot, ClickType.LEFT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean rightClick(@NotNull Player player, int slot) {
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.rightClick(player, this, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, null, convertedSlot, ClickType.RIGHT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean middleClick(@NotNull Player player, int slot) {
        this.update();
        return false;
    }

    @Override
    public boolean drop(@NotNull Player player, boolean all, int slot, int button) {
        ItemStack cursor;
        boolean outsideDrop;
        ItemStack clicked;
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        InventoryClickResult clickResult = this.clickProcessor.drop(player, this, all, convertedSlot, button, clicked = (outsideDrop = slot == -999) ? ItemStack.AIR : this.getItemStack(convertedSlot), cursor = this.getCursorItem());
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        ItemStack resultClicked = clickResult.getClicked();
        if (resultClicked != null && !outsideDrop) {
            this.setItemStack(convertedSlot, resultClicked);
        }
        this.setCursorItem(clickResult.getCursor());
        return true;
    }

    @Override
    public boolean shiftClick(@NotNull Player player, int slot) {
        int end;
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        boolean hotBarClick = SlotUtils.convertSlot((int)slot, (int)9) < 9;
        int start = hotBarClick ? 9 : 0;
        InventoryClickResult clickResult = this.clickProcessor.shiftClick(this, this, start, end = hotBarClick ? this.getSize() - 9 : 8, 1, player, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }

    @Override
    public boolean changeHeld(@NotNull Player player, int slot, int key) {
        int convertedKey = key == 40 ? 45 : key;
        ItemStack cursorItem = this.getCursorItem();
        if (!cursorItem.isAir()) {
            return false;
        }
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        ItemStack heldItem = this.getItemStack(convertedKey);
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.changeHeld(player, this, convertedSlot, convertedKey, clicked, heldItem);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setItemStack(convertedSlot, clickResult.getClicked());
        this.setItemStack(convertedKey, clickResult.getCursor());
        this.callClickEvent(player, null, convertedSlot, ClickType.CHANGE_HELD, clicked, cursorItem);
        return true;
    }

    @Override
    public boolean dragging(@NotNull Player player, int slot, int button) {
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = slot != -999 ? this.getItemStackFromPacketSlot(slot) : ItemStack.AIR;
        InventoryClickResult clickResult = this.clickProcessor.dragging(player, this, SlotUtils.convertPlayerInventorySlot((int)slot, (int)9), button, clicked, cursor);
        if (clickResult == null || clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }

    @Override
    public boolean doubleClick(@NotNull Player player, int slot) {
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        ItemStack cursor = this.getCursorItem();
        ItemStack clicked = this.getItemStack(convertedSlot);
        InventoryClickResult clickResult = this.clickProcessor.doubleClick(this, this, player, convertedSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.update();
            return false;
        }
        this.setCursorItem(clickResult.getCursor());
        this.update();
        return true;
    }

    private void setItemStackFromPacketSlot(int slot, @NotNull ItemStack itemStack) {
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        this.setItemStack(convertedSlot, itemStack);
    }

    private ItemStack getItemStackFromPacketSlot(int slot) {
        int convertedSlot = SlotUtils.convertPlayerInventorySlot((int)slot, (int)9);
        return this.itemStacks[convertedSlot];
    }
}

